/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.acl;

import java.util.Map;
import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class UnionMailboxACLResolverTest {
    private static final Username USER_1 = Username.of((String)"user1");
    private static final Username USER_2 = Username.of((String)"user2");
    private MailboxACL anybodyRead;
    private MailboxACL anybodyReadNegative;
    private UnionMailboxACLResolver anyoneReadListGlobal;
    private MailboxACL authenticatedRead;
    private UnionMailboxACLResolver authenticatedReadListWriteGlobal;
    private MailboxACL authenticatedReadNegative;
    private UnionMailboxACLResolver noGlobals;
    private UnionMailboxACLResolver ownerFullGlobal;
    private MailboxACL ownerRead;
    private MailboxACL ownerReadNegative;
    private MailboxACL user1Read;
    private MailboxACL user1ReadNegative;
    private MailboxACL.EntryKey user1Key;
    private MailboxACL.EntryKey user2Key;

    UnionMailboxACLResolverTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.user1Key = MailboxACL.EntryKey.createUserEntryKey((Username)USER_1);
        this.user2Key = MailboxACL.EntryKey.createUserEntryKey((Username)USER_2);
        MailboxACL acl = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.AUTHENTICATED_KEY, MailboxACL.FULL_RIGHTS)});
        this.authenticatedReadListWriteGlobal = new UnionMailboxACLResolver(acl, acl);
        acl = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.ANYBODY_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"rl"))});
        this.anyoneReadListGlobal = new UnionMailboxACLResolver(acl, acl);
        acl = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.OWNER_KEY, MailboxACL.FULL_RIGHTS)});
        this.ownerFullGlobal = new UnionMailboxACLResolver(acl, acl);
        this.noGlobals = new UnionMailboxACLResolver(MailboxACL.EMPTY, MailboxACL.EMPTY);
        this.user1Read = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(this.user1Key, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.user1ReadNegative = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.EntryKey.createUserEntryKey((Username)USER_1, (boolean)true), MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.anybodyRead = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.ANYBODY_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.anybodyReadNegative = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.ANYBODY_NEGATIVE_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.authenticatedRead = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.AUTHENTICATED_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.authenticatedReadNegative = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.AUTHENTICATED_NEGATIVE_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.ownerRead = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.OWNER_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.ownerReadNegative = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.OWNER_NEGATIVE_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
    }

    @Test
    void testAppliesNullUser() throws UnsupportedRightException {
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user1Key, null, (String)USER_1.asString())).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user2Key, null, (String)USER_1.asString())).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.ANYBODY_KEY, null, (String)USER_1.asString())).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.AUTHENTICATED_KEY, null, (String)USER_1.asString())).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.OWNER_KEY, null, (String)USER_1.asString())).isFalse();
    }

    @Test
    void testAppliesUser() throws UnsupportedRightException {
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user1Key, (MailboxACL.EntryKey)this.user1Key, (String)USER_1.asString())).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user2Key, (MailboxACL.EntryKey)this.user1Key, (String)USER_1.asString())).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.ANYBODY_KEY, (MailboxACL.EntryKey)this.user1Key, (String)USER_1.asString())).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.AUTHENTICATED_KEY, (MailboxACL.EntryKey)this.user1Key, (String)USER_1.asString())).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (MailboxACL.EntryKey)this.user1Key, (String)USER_1.asString())).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user1Key, (MailboxACL.EntryKey)this.user1Key, (String)USER_2.asString())).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user2Key, (MailboxACL.EntryKey)this.user1Key, (String)USER_2.asString())).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.ANYBODY_KEY, (MailboxACL.EntryKey)this.user1Key, (String)USER_2.asString())).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.AUTHENTICATED_KEY, (MailboxACL.EntryKey)this.user1Key, (String)USER_2.asString())).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (MailboxACL.EntryKey)this.user1Key, (String)USER_2.asString())).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user1Key, (MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (String)USER_1.asString())).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user2Key, (MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (String)USER_1.asString())).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.ANYBODY_KEY, (MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (String)USER_1.asString())).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.AUTHENTICATED_KEY, (MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (String)USER_1.asString())).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (String)USER_1.asString())).isTrue();
    }

    @Test
    void testResolveRightsNullUser() throws UnsupportedRightException {
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, this.user1Read, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, this.user1Read, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, this.user1ReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, this.user1Read, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, this.user1ReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, this.user1Read, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, this.user1ReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, this.user1Read, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, this.user1ReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, this.anybodyRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, this.anybodyReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, this.anybodyRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, this.anybodyReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, this.anybodyRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, this.anybodyReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, this.anybodyRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, this.anybodyReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, this.authenticatedRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, this.authenticatedReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, this.authenticatedRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, this.authenticatedReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, this.authenticatedRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, this.authenticatedReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, this.authenticatedRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, this.authenticatedReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, this.ownerRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, this.ownerReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, this.ownerRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, this.ownerReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, this.ownerRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, this.ownerReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, this.ownerRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, this.ownerReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
    }

    @Test
    void testResolveRightsNullUserGlobals() throws UnsupportedRightException {
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, this.user1Read, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, MailboxACL.EMPTY, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, MailboxACL.EMPTY, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, MailboxACL.EMPTY, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
    }

    @Test
    void testResolveRightsUserSelfOwner() throws UnsupportedRightException {
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.user1Read, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.user1ReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.user1Read, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.user1ReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.user1Read, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.user1ReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.user1Read, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.user1ReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.anybodyRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.anybodyReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.anybodyRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.anybodyReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.anybodyRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.anybodyReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.anybodyRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.anybodyReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.authenticatedRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.authenticatedReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.authenticatedRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.authenticatedReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.authenticatedRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.authenticatedReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.authenticatedRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.authenticatedReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.ownerRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.ownerReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.ownerRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.ownerReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.ownerRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.ownerReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.ownerRead, USER_1.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.ownerReadNegative, USER_1.asString()).contains(MailboxACL.Right.Read)).isFalse();
    }

    @Test
    void testResolveRightsUserNotOwner() throws UnsupportedRightException {
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.user1Read, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.user1ReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.user1Read, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.user1ReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.user1Read, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.user1ReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.user1Read, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.user1ReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.anybodyRead, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.anybodyReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.anybodyRead, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.anybodyReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.anybodyRead, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.anybodyReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.anybodyRead, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.anybodyReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.authenticatedRead, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.authenticatedReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.authenticatedRead, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.authenticatedReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.authenticatedRead, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.authenticatedReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.authenticatedRead, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.authenticatedReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.ownerRead, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, this.ownerReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.ownerRead, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, this.ownerReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.ownerRead, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, this.ownerReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.ownerRead, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, this.ownerReadNegative, USER_2.asString()).contains(MailboxACL.Right.Read)).isFalse();
    }
}

