/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.manager;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import javax.mail.Flags;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.manager.IntegrationResources;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.quota.MaxQuotaManager;

public class ManagerTestProvisionner {
    public static final Username USER = Username.of((String)"user@domain.org");
    public static final String USER_PASS = "pass";
    public static final Username OTHER_USER = Username.of((String)"otherUser@domain.org");
    public static final String OTHER_USER_PASS = "otherPass";
    public static final MailboxPath INBOX = MailboxPath.inbox((Username)USER);
    private IntegrationResources<?> integrationResources;
    private MessageManager messageManager;
    private MailboxPath subFolder;
    private MailboxSession session;

    public ManagerTestProvisionner(IntegrationResources<?> integrationResources) throws Exception {
        this.integrationResources = integrationResources;
        this.session = integrationResources.getMailboxManager().login(USER, USER_PASS);
        this.subFolder = new MailboxPath(INBOX, "INBOX.SUB");
        MaxQuotaManager maxQuotaManager = integrationResources.getMaxQuotaManager();
        maxQuotaManager.setGlobalMaxMessage(QuotaCountLimit.count((long)1000L));
        maxQuotaManager.setGlobalMaxStorage(QuotaSizeLimit.size((long)1000000L));
    }

    public void createMailboxes() throws MailboxException {
        this.integrationResources.getMailboxManager().createMailbox(INBOX, this.session);
        this.integrationResources.getMailboxManager().createMailbox(this.subFolder, this.session);
        this.messageManager = this.integrationResources.getMailboxManager().getMailbox(INBOX, this.session);
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public MailboxPath getSubFolder() {
        return this.subFolder;
    }

    public MailboxSession getSession() {
        return this.session;
    }

    public void fillMailbox() throws MailboxException, UnsupportedEncodingException {
        for (int i = 0; i < 4; ++i) {
            this.provideSomeMessages();
        }
    }

    private void provideSomeMessages() throws MailboxException, UnsupportedEncodingException {
        this.appendMessage(this.messageManager, this.session, new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.SEEN}).build());
        this.appendMessage(this.messageManager, this.session, new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.DELETED}).build());
        this.appendMessage(this.messageManager, this.session, new FlagsBuilder().build());
        this.appendMessage(this.messageManager, this.session, new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.RECENT}).build());
    }

    public MessageUid appendMessage(MessageManager messageManager, MailboxSession session, Flags flags) throws MailboxException, UnsupportedEncodingException {
        return messageManager.appendMessage((InputStream)new ByteArrayInputStream("Date: Mon, 7 Feb 1994 21:52:25 -0800 (PST)\nFrom: Fred Foobar <foobar@Blurdybloop.COM>\nSubject: Test 03\nTo: mooch@owatagu.siam.edu\nMessage-Id: <B27397-0100000@Blurdybloop.COM>\nMIME-Version: 1.0\nContent-Type: TEXT/PLAIN; CHARSET=US-ASCII\n\nMock Mail\n".getBytes(StandardCharsets.UTF_8)), Calendar.getInstance().getTime(), session, true, flags).getId().getUid();
    }
}

