/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.manager;

import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.apache.james.mailbox.manager.IntegrationResources;
import org.apache.james.mailbox.manager.ManagerTestProvisionner;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mime4j.dom.Message;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

public interface QuotaMessageManagerContract<T extends MailboxManager> {
    public IntegrationResources<T> getResources();

    public ManagerTestProvisionner getProvisionner();

    @Test
    default public void testAppendOverQuotaMessages() throws Exception {
        ManagerTestProvisionner provisionner = this.getProvisionner();
        IntegrationResources<T> resources = this.getResources();
        QuotaCountLimit maxMessageCount = QuotaCountLimit.count((long)8L);
        resources.getMaxQuotaManager().setMaxMessage(resources.getQuotaRootResolver().getQuotaRoot(ManagerTestProvisionner.INBOX), maxMessageCount);
        Assertions.assertThatThrownBy(() -> provisionner.fillMailbox()).isInstanceOf(OverQuotaException.class);
    }

    @Test
    default public void testAppendOverQuotaSize() throws Exception {
        ManagerTestProvisionner provisionner = this.getProvisionner();
        IntegrationResources<T> resources = this.getResources();
        QuotaSizeLimit maxQuotaSize = QuotaSizeLimit.size((long)(3 * "Date: Mon, 7 Feb 1994 21:52:25 -0800 (PST)\nFrom: Fred Foobar <foobar@Blurdybloop.COM>\nSubject: Test 03\nTo: mooch@owatagu.siam.edu\nMessage-Id: <B27397-0100000@Blurdybloop.COM>\nMIME-Version: 1.0\nContent-Type: TEXT/PLAIN; CHARSET=US-ASCII\n\nMock Mail\n".length() + 1));
        resources.getMaxQuotaManager().setMaxStorage(resources.getQuotaRootResolver().getQuotaRoot(ManagerTestProvisionner.INBOX), maxQuotaSize);
        Assertions.assertThatThrownBy(() -> provisionner.fillMailbox()).isInstanceOf(OverQuotaException.class);
    }

    @Test
    default public void testCopyOverQuotaMessages() throws Exception {
        ManagerTestProvisionner provisionner = this.getProvisionner();
        IntegrationResources resources = this.getResources();
        try {
            provisionner.fillMailbox();
        }
        catch (OverQuotaException overQuotaException) {
            // empty catch block
        }
        QuotaCountLimit maxMessageCount = QuotaCountLimit.count((long)15L);
        resources.getMaxQuotaManager().setMaxMessage(resources.getQuotaRootResolver().getQuotaRoot(ManagerTestProvisionner.INBOX), maxMessageCount);
        Assertions.assertThatThrownBy(() -> resources.getMailboxManager().copyMessages(MessageRange.all(), ManagerTestProvisionner.INBOX, provisionner.getSubFolder(), provisionner.getSession())).isInstanceOf(OverQuotaException.class);
    }

    @Test
    default public void testCopyOverQuotaSize() throws Exception {
        ManagerTestProvisionner provisionner = this.getProvisionner();
        IntegrationResources resources = this.getResources();
        QuotaSizeLimit maxQuotaSize = QuotaSizeLimit.size((long)(15L * (long)"Date: Mon, 7 Feb 1994 21:52:25 -0800 (PST)\nFrom: Fred Foobar <foobar@Blurdybloop.COM>\nSubject: Test 03\nTo: mooch@owatagu.siam.edu\nMessage-Id: <B27397-0100000@Blurdybloop.COM>\nMIME-Version: 1.0\nContent-Type: TEXT/PLAIN; CHARSET=US-ASCII\n\nMock Mail\n".length()));
        resources.getMaxQuotaManager().setMaxStorage(resources.getQuotaRootResolver().getQuotaRoot(ManagerTestProvisionner.INBOX), maxQuotaSize);
        try {
            provisionner.fillMailbox();
        }
        catch (OverQuotaException overQuotaException) {
            // empty catch block
        }
        Assertions.assertThatThrownBy(() -> resources.getMailboxManager().copyMessages(MessageRange.all(), ManagerTestProvisionner.INBOX, provisionner.getSubFolder(), provisionner.getSession())).isInstanceOf(OverQuotaException.class);
    }

    @Test
    default public void testRetrievalOverMaxMessageAfterExpunge() throws Exception {
        ManagerTestProvisionner provisionner = this.getProvisionner();
        IntegrationResources<T> resources = this.getResources();
        QuotaCountLimit maxMessageCount = QuotaCountLimit.count((long)15L);
        resources.getMaxQuotaManager().setMaxMessage(resources.getQuotaRootResolver().getQuotaRoot(ManagerTestProvisionner.INBOX), maxMessageCount);
        try {
            provisionner.fillMailbox();
        }
        catch (OverQuotaException overQuotaException) {
            // empty catch block
        }
        provisionner.getMessageManager().expunge(MessageRange.all(), provisionner.getSession());
        Assertions.assertThatCode(() -> provisionner.appendMessage(provisionner.getMessageManager(), provisionner.getSession(), new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.SEEN}).build())).doesNotThrowAnyException();
    }

    @Test
    default public void testRetrievalOverMaxStorageAfterExpunge() throws Exception {
        ManagerTestProvisionner provisionner = this.getProvisionner();
        IntegrationResources<T> resources = this.getResources();
        QuotaSizeLimit maxQuotaSize = QuotaSizeLimit.size((long)(15 * "Date: Mon, 7 Feb 1994 21:52:25 -0800 (PST)\nFrom: Fred Foobar <foobar@Blurdybloop.COM>\nSubject: Test 03\nTo: mooch@owatagu.siam.edu\nMessage-Id: <B27397-0100000@Blurdybloop.COM>\nMIME-Version: 1.0\nContent-Type: TEXT/PLAIN; CHARSET=US-ASCII\n\nMock Mail\n".getBytes(StandardCharsets.UTF_8).length + 1));
        resources.getMaxQuotaManager().setMaxStorage(resources.getQuotaRootResolver().getQuotaRoot(ManagerTestProvisionner.INBOX), maxQuotaSize);
        try {
            provisionner.fillMailbox();
        }
        catch (OverQuotaException overQuotaException) {
            // empty catch block
        }
        provisionner.getMessageManager().expunge(MessageRange.all(), provisionner.getSession());
        Assertions.assertThatCode(() -> provisionner.appendMessage(provisionner.getMessageManager(), provisionner.getSession(), new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.SEEN}).build())).doesNotThrowAnyException();
    }

    @Test
    default public void testRetrievalOverMaxMessageAfterDelete() throws Exception {
        ManagerTestProvisionner provisionner = this.getProvisionner();
        IntegrationResources<T> resources = this.getResources();
        QuotaCountLimit maxMessageCount = QuotaCountLimit.count((long)15L);
        resources.getMaxQuotaManager().setMaxMessage(resources.getQuotaRootResolver().getQuotaRoot(ManagerTestProvisionner.INBOX), maxMessageCount);
        try {
            provisionner.fillMailbox();
        }
        catch (OverQuotaException overQuotaException) {
            // empty catch block
        }
        List uids = provisionner.getMessageManager().getMetaData(true, provisionner.getSession(), MessageManager.MailboxMetaData.FetchGroup.UNSEEN_COUNT).getRecent();
        provisionner.getMessageManager().delete(uids, provisionner.getSession());
        Assertions.assertThatCode(() -> provisionner.appendMessage(provisionner.getMessageManager(), provisionner.getSession(), new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.SEEN}).build())).doesNotThrowAnyException();
    }

    @Test
    default public void testRetrievalOverMaxStorageAfterDelete() throws Exception {
        ManagerTestProvisionner provisionner = this.getProvisionner();
        IntegrationResources<T> resources = this.getResources();
        QuotaSizeLimit maxQuotaSize = QuotaSizeLimit.size((long)(15 * "Date: Mon, 7 Feb 1994 21:52:25 -0800 (PST)\nFrom: Fred Foobar <foobar@Blurdybloop.COM>\nSubject: Test 03\nTo: mooch@owatagu.siam.edu\nMessage-Id: <B27397-0100000@Blurdybloop.COM>\nMIME-Version: 1.0\nContent-Type: TEXT/PLAIN; CHARSET=US-ASCII\n\nMock Mail\n".getBytes(StandardCharsets.UTF_8).length + 1));
        resources.getMaxQuotaManager().setMaxStorage(resources.getQuotaRootResolver().getQuotaRoot(ManagerTestProvisionner.INBOX), maxQuotaSize);
        try {
            provisionner.fillMailbox();
        }
        catch (OverQuotaException overQuotaException) {
            // empty catch block
        }
        List uids = provisionner.getMessageManager().getMetaData(true, provisionner.getSession(), MessageManager.MailboxMetaData.FetchGroup.UNSEEN_COUNT).getRecent();
        provisionner.getMessageManager().delete(uids, provisionner.getSession());
        Assertions.assertThatCode(() -> provisionner.appendMessage(provisionner.getMessageManager(), provisionner.getSession(), new FlagsBuilder().add(new Flags.Flag[]{Flags.Flag.SEEN}).build())).doesNotThrowAnyException();
    }

    @Test
    default public void deletingAMailboxShouldDecreaseCurrentQuota() throws Exception {
        ManagerTestProvisionner provisionner = this.getProvisionner();
        IntegrationResources<T> resources = this.getResources();
        provisionner.fillMailbox();
        resources.getMailboxManager().deleteMailbox(ManagerTestProvisionner.INBOX, provisionner.getSession());
        QuotaRoot quotaRoot = resources.getQuotaRootResolver().getQuotaRoot(ManagerTestProvisionner.INBOX);
        Quota messageQuota = resources.getQuotaManager().getMessageQuota(quotaRoot);
        Quota storageQuota = resources.getQuotaManager().getStorageQuota(quotaRoot);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Object)((QuotaCountUsage)messageQuota.getUsed())).isEqualTo((Object)QuotaCountUsage.count((long)0L));
            softly.assertThat((Object)((QuotaSizeUsage)storageQuota.getUsed())).isEqualTo((Object)QuotaSizeUsage.size((long)0L));
        });
    }

    @Test
    default public void deletingAMailboxShouldPreserveQuotaOfOtherMailboxes() throws Exception {
        ManagerTestProvisionner provisionner = this.getProvisionner();
        IntegrationResources<T> resources = this.getResources();
        provisionner.fillMailbox();
        resources.getMailboxManager().getMailbox(provisionner.getSubFolder(), provisionner.getSession()).appendMessage(MessageManager.AppendCommand.from((Message)Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build()), provisionner.getSession());
        resources.getMailboxManager().deleteMailbox(provisionner.getSubFolder(), provisionner.getSession());
        QuotaRoot quotaRoot = resources.getQuotaRootResolver().getQuotaRoot(ManagerTestProvisionner.INBOX);
        Quota messageQuota = resources.getQuotaManager().getMessageQuota(quotaRoot);
        Quota storageQuota = resources.getQuotaManager().getStorageQuota(quotaRoot);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Object)((QuotaCountUsage)messageQuota.getUsed())).isEqualTo((Object)QuotaCountUsage.count((long)16L));
            softly.assertThat((Object)((QuotaSizeUsage)storageQuota.getUsed())).isEqualTo((Object)QuotaSizeUsage.size((long)3952L));
        });
    }
}

