/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.mock;

import java.util.stream.IntStream;
import javax.mail.Flags;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;

public class DataProvisioner {
    public static final int DOMAIN_COUNT = 3;
    public static final int USER_COUNT = 3;
    public static final int SUB_MAILBOXES_COUNT = 3;
    public static final int SUB_SUB_MAILBOXES_COUNT = 3;
    public static final int EXPECTED_MAILBOXES_COUNT = 117;
    public static final int MESSAGE_PER_MAILBOX_COUNT = 3;

    public static void feedMailboxManager(MailboxManager mailboxManager) {
        IntStream.range(0, 3).mapToObj(i -> "localhost" + i).forEach(domain -> DataProvisioner.provisionDomain(mailboxManager, domain));
    }

    public static void provisionDomain(MailboxManager mailboxManager, String domain) {
        IntStream.range(0, 3).mapToObj(i -> "user" + i + "@" + domain).map(Username::of).forEach(user -> DataProvisioner.provisionUser(mailboxManager, user));
    }

    private static void provisionUser(MailboxManager mailboxManager, Username user) {
        MailboxSession mailboxSession = mailboxManager.createSystemSession(user);
        mailboxManager.startProcessingRequest(mailboxSession);
        DataProvisioner.createMailbox(mailboxManager, mailboxSession, MailboxPath.inbox((MailboxSession)mailboxSession));
        IntStream.range(0, 3).mapToObj(i -> "INBOX.SUB_FOLDER_" + i).peek(name -> DataProvisioner.createMailbox(mailboxManager, mailboxSession, MailboxPath.forUser((Username)user, (String)name))).forEach(name -> DataProvisioner.createSubSubMailboxes(mailboxManager, mailboxSession, name));
        mailboxManager.endProcessingRequest(mailboxSession);
        mailboxManager.logout(mailboxSession);
    }

    private static void createSubSubMailboxes(MailboxManager mailboxManager, MailboxSession mailboxSession, String subFolderName) {
        IntStream.range(0, 3).mapToObj(i -> subFolderName + ".SUBSUB_FOLDER_" + i).forEach(name -> DataProvisioner.createMailbox(mailboxManager, mailboxSession, MailboxPath.forUser((Username)mailboxSession.getUser(), (String)name)));
    }

    private static void createMailbox(MailboxManager mailboxManager, MailboxSession mailboxSession, MailboxPath mailboxPath) {
        try {
            mailboxManager.createMailbox(mailboxPath, mailboxSession);
            MessageManager messageManager = mailboxManager.getMailbox(mailboxPath, mailboxSession);
            IntStream.range(0, 3).forEach(i -> DataProvisioner.appendMessage(messageManager, mailboxSession));
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void appendMessage(MessageManager messageManager, MailboxSession mailboxSession) {
        try {
            messageManager.appendMessage(MessageManager.AppendCommand.builder().recent().withFlags(new Flags(Flags.Flag.RECENT)).build("Date: Mon, 7 Feb 1994 21:52:25 -0800 (PST)\nFrom: Fred Foobar <foobar@Blurdybloop.COM>\nSubject: Test 03\nTo: mooch@owatagu.siam.edu\nMessage-Id: <B27397-0100000@Blurdybloop.COM>\nMIME-Version: 1.0\nContent-Type: TEXT/PLAIN; CHARSET=US-ASCII\n\nMock Mail\n"), mailboxSession);
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }
}

