/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.model.Cid;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CidTest {
    CidTest() {
    }

    @Test
    void fromShouldThrowWhenNull() {
        Assertions.assertThatThrownBy(() -> Cid.from(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromShouldThrowWhenEmpty() {
        Assertions.assertThatThrownBy(() -> Cid.from((String)"")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromShouldThrowWhenBlank() {
        Assertions.assertThatThrownBy(() -> Cid.from((String)"    ")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromShouldThrowWhenEmptyAfterRemoveTags() {
        Assertions.assertThatThrownBy(() -> Cid.from((String)"<>")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromShouldThrowWhenBlankAfterRemoveTags() {
        Assertions.assertThatThrownBy(() -> Cid.from((String)"<   >")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromShouldRemoveTagsWhenExists() {
        Cid cid = Cid.from((String)"<123>");
        Assertions.assertThat((String)cid.getValue()).isEqualTo("123");
    }

    @Test
    void fromShouldNotRemoveTagsWhenNone() {
        Cid cid = Cid.from((String)"123");
        Assertions.assertThat((String)cid.getValue()).isEqualTo("123");
    }

    @Test
    void fromShouldNotRemoveTagsWhenNotEndTag() {
        Cid cid = Cid.from((String)"<123");
        Assertions.assertThat((String)cid.getValue()).isEqualTo("<123");
    }

    @Test
    void fromShouldNotRemoveTagsWhenNotStartTag() {
        Cid cid = Cid.from((String)"123>");
        Assertions.assertThat((String)cid.getValue()).isEqualTo("123>");
    }

    @Test
    void fromRelaxedNoUnwrapShouldReturnAbsentWhenNull() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().parse(null)).isEmpty();
    }

    @Test
    void fromRelaxedNoUnwrapShouldReturnAbsentWhenEmpty() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().parse("")).isEmpty();
    }

    @Test
    void fromRelaxedNoUnwrapShouldReturnAbsentWhenBlank() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().parse("     ")).isEmpty();
    }

    @Test
    void fromRelaxedNoUnwrapShouldReturnCidWhenEmptyAfterRemoveTags() {
        Optional actual = Cid.parser().relaxed().parse("<>");
        Assertions.assertThat((Optional)actual).isPresent();
        Assertions.assertThat((String)((Cid)actual.get()).getValue()).isEqualTo("<>");
    }

    @Test
    void fromRelaxedNoUnwrapShouldReturnCidWhenBlankAfterRemoveTags() {
        Optional actual = Cid.parser().relaxed().parse("<   >");
        Assertions.assertThat((Optional)actual).isPresent();
        Assertions.assertThat((String)((Cid)actual.get()).getValue()).isEqualTo("<   >");
    }

    @Test
    void fromRelaxedNoUnwrapShouldNotRemoveTagsWhenExists() {
        Optional actual = Cid.parser().relaxed().parse("<123>");
        Assertions.assertThat((Optional)actual).isPresent();
        Assertions.assertThat((String)((Cid)actual.get()).getValue()).isEqualTo("<123>");
    }

    @Test
    void fromRelaxedNoUnwrapShouldNotRemoveTagsWhenNone() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().parse("123")).contains((Object)Cid.from((String)"123"));
    }

    @Test
    void fromRelaxedNoUnwrapShouldNotRemoveTagsWhenNotEndTag() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().parse("<123")).contains((Object)Cid.from((String)"<123"));
    }

    @Test
    void fromRelaxedNoUnwrapShouldNotRemoveTagsWhenNotStartTag() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().parse("123>")).contains((Object)Cid.from((String)"123>"));
    }

    @Test
    void fromRelaxedUnwrapShouldReturnAbsentWhenNull() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().unwrap().parse(null)).isEmpty();
    }

    @Test
    void fromRelaxedUnwrapShouldReturnAbsentWhenEmpty() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().unwrap().parse("")).isEmpty();
    }

    @Test
    void fromRelaxedUnwrapShouldReturnAbsentWhenBlank() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().unwrap().parse("     ")).isEmpty();
    }

    @Test
    void fromRelaxedUnwrapShouldReturnAbsentWhenEmptyAfterRemoveTags() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().unwrap().parse("<>")).isEmpty();
    }

    @Test
    void fromRelaxedUnwrapShouldReturnAbsentWhenBlankAfterRemoveTags() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().unwrap().parse("<   >")).isEmpty();
    }

    @Test
    void fromRelaxedUnwrapShouldRemoveTagsWhenExists() {
        Optional actual = Cid.parser().relaxed().unwrap().parse("<123>");
        Assertions.assertThat((Optional)actual).isPresent();
        Assertions.assertThat((String)((Cid)actual.get()).getValue()).isEqualTo("123");
    }

    @Test
    void fromRelaxedUnwrapShouldNotRemoveTagsWhenNone() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().unwrap().parse("123")).contains((Object)Cid.from((String)"123"));
    }

    @Test
    void fromRelaxedUnwrapShouldNotRemoveTagsWhenNotEndTag() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().unwrap().parse("<123")).contains((Object)Cid.from((String)"<123"));
    }

    @Test
    void fromRelaxedUnwrapShouldNotRemoveTagsWhenNotStartTag() {
        Assertions.assertThat((Optional)Cid.parser().relaxed().unwrap().parse("123>")).contains((Object)Cid.from((String)"123>"));
    }

    @Test
    void fromStrictNoUnwrapShouldThrowWhenNull() {
        Assertions.assertThatThrownBy(() -> Cid.parser().strict().parse(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromStrictNoUnwrapShouldThrowWhenEmpty() {
        Assertions.assertThatThrownBy(() -> Cid.parser().strict().parse("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromStrinctNoUnwrapShouldThrowWhenBlank() {
        Assertions.assertThatThrownBy(() -> Cid.parser().strict().parse("   ")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromStrictNoUnwrapShouldNotRemoveTagWhenEmptyAfterRemoveTags() {
        Optional actual = Cid.parser().strict().parse("<>");
        Assertions.assertThat((Optional)actual).isPresent();
        Assertions.assertThat((String)((Cid)actual.get()).getValue()).isEqualTo("<>");
    }

    @Test
    void fromStrictNoUnwrapShouldNotRemoveTagWhenBlankAfterRemoveTags() {
        Optional actual = Cid.parser().strict().parse("<   >");
        Assertions.assertThat((Optional)actual).isPresent();
        Assertions.assertThat((String)((Cid)actual.get()).getValue()).isEqualTo("<   >");
    }

    @Test
    void fromStrictNoUnwrapShouldNotRemoveTagsWhenExists() {
        Optional actual = Cid.parser().strict().parse("<123>");
        Assertions.assertThat((Optional)actual).isPresent();
        Assertions.assertThat((String)((Cid)actual.get()).getValue()).isEqualTo("<123>");
    }

    @Test
    void fromStrictNoUnwrapShouldNotRemoveTagsWhenNone() {
        Assertions.assertThat((Optional)Cid.parser().strict().parse("123")).contains((Object)Cid.from((String)"123"));
    }

    @Test
    void fromStrictNoUnwrapShouldNotRemoveTagsWhenNotEndTag() {
        Assertions.assertThat((Optional)Cid.parser().strict().parse("<123")).contains((Object)Cid.from((String)"<123"));
    }

    @Test
    void fromStrictNoUnwrapShouldNotRemoveTagsWhenNotStartTag() {
        Assertions.assertThat((Optional)Cid.parser().strict().parse("123>")).contains((Object)Cid.from((String)"123>"));
    }

    @Test
    void shouldRespectJavaBeanContract() {
        EqualsVerifier.forClass(Cid.class).verify();
    }
}

