/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import javax.mail.Flags;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.mailbox.model.ThreadId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ComposedMessageIdWithMetaDataTest {
    private static final TestId TEST_ID = TestId.of(1L);
    private static final TestMessageId TEST_MESSAGE_ID = new TestMessageId("2");
    private static final MessageUid MESSAGE_UID = MessageUid.of((long)3L);
    private static final ComposedMessageId COMPOSED_MESSAGE_ID = new ComposedMessageId((MailboxId)TEST_ID, (MessageId)TEST_MESSAGE_ID, MESSAGE_UID);
    private static final ThreadId THREAD_ID = ThreadId.fromBaseMessageId((MessageId)TEST_MESSAGE_ID);

    ComposedMessageIdWithMetaDataTest() {
    }

    @Test
    void buildShouldThrownWhenComposedMessageIdIsNull() {
        Assertions.assertThatThrownBy(() -> ComposedMessageIdWithMetaData.builder().build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldThrownWhenFlagsIsNull() {
        Assertions.assertThatThrownBy(() -> ComposedMessageIdWithMetaData.builder().composedMessageId(COMPOSED_MESSAGE_ID).build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldThrownWhenModSeqIsNull() {
        Assertions.assertThatThrownBy(() -> ComposedMessageIdWithMetaData.builder().composedMessageId(COMPOSED_MESSAGE_ID).flags(new Flags()).build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldThrownWhenThreadIdIsNull() {
        Assertions.assertThatThrownBy(() -> ComposedMessageIdWithMetaData.builder().composedMessageId(COMPOSED_MESSAGE_ID).flags(new Flags()).modSeq(ModSeq.of((long)1L)).build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldWork() {
        Flags flags = new Flags(Flags.Flag.RECENT);
        ModSeq modSeq = ModSeq.of((long)1L);
        ComposedMessageIdWithMetaData composedMessageIdWithMetaData = ComposedMessageIdWithMetaData.builder().composedMessageId(COMPOSED_MESSAGE_ID).flags(flags).modSeq(modSeq).threadId(THREAD_ID).build();
        Assertions.assertThat((Object)composedMessageIdWithMetaData.getComposedMessageId()).isEqualTo((Object)COMPOSED_MESSAGE_ID);
        Assertions.assertThat((Object)composedMessageIdWithMetaData.getFlags()).isEqualTo((Object)flags);
        Assertions.assertThat((Comparable)composedMessageIdWithMetaData.getModSeq()).isEqualTo((Object)modSeq);
        Assertions.assertThat((Object)composedMessageIdWithMetaData.getThreadId()).isEqualTo((Object)THREAD_ID);
    }

    @Test
    void isMatchingShouldReturnTrueWhenSameMessageId() {
        ComposedMessageIdWithMetaData composedMessageIdWithMetaData = ComposedMessageIdWithMetaData.builder().composedMessageId(new ComposedMessageId((MailboxId)TEST_ID, (MessageId)TEST_MESSAGE_ID, MESSAGE_UID)).flags(new Flags(Flags.Flag.RECENT)).modSeq(ModSeq.of((long)1L)).threadId(THREAD_ID).build();
        Assertions.assertThat((boolean)composedMessageIdWithMetaData.isMatching((MessageId)TEST_MESSAGE_ID)).isTrue();
    }

    @Test
    void isMatchingShouldReturnFalseWhenOtherMessageId() {
        ComposedMessageIdWithMetaData composedMessageIdWithMetaData = ComposedMessageIdWithMetaData.builder().composedMessageId(COMPOSED_MESSAGE_ID).flags(new Flags(Flags.Flag.RECENT)).modSeq(ModSeq.of((long)1L)).threadId(THREAD_ID).build();
        Assertions.assertThat((boolean)composedMessageIdWithMetaData.isMatching((MessageId)new TestMessageId("3"))).isFalse();
    }

    @Test
    void shouldRespectJavaBeanContract() {
        EqualsVerifier.forClass(ComposedMessageIdWithMetaData.class).verify();
    }

    private static class TestMessageId
    implements MessageId {
        private final String id;

        public TestMessageId(String id) {
            this.id = id;
        }

        public String serialize() {
            return this.id;
        }

        public boolean isSerializable() {
            return true;
        }
    }
}

