/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MailboxACLTest {
    private static final String USER_1 = "user1";
    private static final String USER_2 = "user2";
    private static final Username USERNAME_1 = Username.of((String)"user1");
    private static final Username USERNAME_2 = Username.of((String)"user2");
    private static final boolean NEGATIVE = true;
    private static final String ae = "ae";
    private static final String ik = "ik";
    private static final String aeik = "aeik";
    private static final String lprs = "lprs";
    private static final String twx = "twx";
    private Properties u1u2g1g2Properties;
    private MailboxACL u1u2g1g2ACL;

    MailboxACLTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.u1u2g1g2Properties = new Properties();
        this.u1u2g1g2Properties.setProperty(USER_1, aeik);
        this.u1u2g1g2Properties.setProperty("-user1", lprs);
        this.u1u2g1g2Properties.setProperty(USER_2, lprs);
        this.u1u2g1g2Properties.setProperty("-user2", twx);
        this.u1u2g1g2ACL = new MailboxACL(this.u1u2g1g2Properties);
    }

    @Test
    void shouldRespectBeanContract() {
        EqualsVerifier.forClass(MailboxACL.class).verify();
    }

    @Test
    void rfc4314RightsShouldRespectBeanContract() {
        EqualsVerifier.forClass(MailboxACL.Rfc4314Rights.class).verify();
    }

    @Test
    void testUnionACLNew() throws UnsupportedRightException {
        HashMap<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> expectedEntries = new HashMap<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights>(this.u1u2g1g2ACL.getEntries());
        expectedEntries.put(MailboxACL.OWNER_KEY, MailboxACL.FULL_RIGHTS);
        MailboxACL toAdd = MailboxACL.OWNER_FULL_ACL;
        MailboxACL result = this.u1u2g1g2ACL.union(toAdd);
        Map foundEntries = result.getEntries();
        Assertions.assertThat(expectedEntries).isEqualTo((Object)foundEntries);
    }

    @Test
    void testUnionEntryNew() throws UnsupportedRightException {
        HashMap<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> expectedEntries = new HashMap<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights>(this.u1u2g1g2ACL.getEntries());
        expectedEntries.put(MailboxACL.OWNER_KEY, MailboxACL.FULL_RIGHTS);
        MailboxACL result = this.u1u2g1g2ACL.union(MailboxACL.OWNER_KEY, MailboxACL.FULL_RIGHTS);
        Map foundEntries = result.getEntries();
        Assertions.assertThat((Map)foundEntries).isEqualTo(expectedEntries);
    }

    @Test
    void testUnionACLExisting() throws UnsupportedRightException {
        HashMap<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> expectedEntries = new HashMap<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights>(this.u1u2g1g2ACL.getEntries());
        expectedEntries.put(MailboxACL.EntryKey.deserialize((String)USER_1), MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"aeiklprs"));
        MailboxACL toAdd = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(USER_1, lprs)});
        MailboxACL result = this.u1u2g1g2ACL.union(toAdd);
        Map foundEntries = result.getEntries();
        Assertions.assertThat(expectedEntries).isEqualTo((Object)foundEntries);
    }

    @Test
    void testUnionEntryExisting() throws UnsupportedRightException {
        HashMap<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> expectedEntries = new HashMap<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights>(this.u1u2g1g2ACL.getEntries());
        expectedEntries.put(MailboxACL.EntryKey.deserialize((String)USER_1), MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"aeiklprs"));
        MailboxACL result = this.u1u2g1g2ACL.union(MailboxACL.EntryKey.deserialize((String)USER_1), MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)lprs));
        Map foundEntries = result.getEntries();
        Assertions.assertThat((Map)foundEntries).isEqualTo(expectedEntries);
    }

    @Test
    void testUnionACLZero() throws UnsupportedRightException {
    }

    @Test
    void testUnionEntryZero() throws UnsupportedRightException {
    }

    @Test
    void testExceptACLNew() throws UnsupportedRightException {
        HashMap expectedEntries = new HashMap(this.u1u2g1g2ACL.getEntries());
        MailboxACL toRemove = MailboxACL.OWNER_FULL_ACL;
        MailboxACL result = this.u1u2g1g2ACL.except(toRemove);
        Map foundEntries = result.getEntries();
        Assertions.assertThat(expectedEntries).isEqualTo((Object)foundEntries);
    }

    @Test
    void testExceptEntryNew() throws UnsupportedRightException {
        HashMap expectedEntries = new HashMap(this.u1u2g1g2ACL.getEntries());
        MailboxACL result = this.u1u2g1g2ACL.except(MailboxACL.OWNER_KEY, MailboxACL.FULL_RIGHTS);
        Map foundEntries = result.getEntries();
        Assertions.assertThat(expectedEntries).isEqualTo((Object)foundEntries);
    }

    @Test
    void testExceptACLExisting() throws UnsupportedRightException {
        HashMap<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> expectedEntries = new HashMap<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights>(this.u1u2g1g2ACL.getEntries());
        expectedEntries.put(MailboxACL.EntryKey.deserialize((String)USER_1), MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)ik));
        MailboxACL toRemove = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(USER_1, ae)});
        MailboxACL result = this.u1u2g1g2ACL.except(toRemove);
        Map foundEntries = result.getEntries();
        Assertions.assertThat((Map)foundEntries).isEqualTo(expectedEntries);
    }

    @Test
    void testExceptEntryExisting() throws UnsupportedRightException {
        HashMap<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> expectedEntries = new HashMap<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights>(this.u1u2g1g2ACL.getEntries());
        expectedEntries.put(MailboxACL.EntryKey.deserialize((String)USER_1), MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)ik));
        MailboxACL result = this.u1u2g1g2ACL.except(MailboxACL.EntryKey.deserialize((String)USER_1), MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)ae));
        Map foundEntries = result.getEntries();
        Assertions.assertThat((Map)foundEntries).isEqualTo(expectedEntries);
    }

    @Test
    void testExceptACLFull() throws UnsupportedRightException {
        HashMap expectedEntries = new HashMap(this.u1u2g1g2ACL.getEntries());
        expectedEntries.remove(MailboxACL.EntryKey.deserialize((String)USER_1));
        MailboxACL toRemove = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(USER_1, MailboxACL.FULL_RIGHTS.serialize())});
        MailboxACL result = this.u1u2g1g2ACL.except(toRemove);
        Map foundEntries = result.getEntries();
        Assertions.assertThat((Map)foundEntries).isEqualTo(expectedEntries);
    }

    @Test
    void testExceptEntryFull() throws UnsupportedRightException {
        HashMap expectedEntries = new HashMap(this.u1u2g1g2ACL.getEntries());
        expectedEntries.remove(MailboxACL.EntryKey.deserialize((String)USER_1));
        MailboxACL result = this.u1u2g1g2ACL.except(MailboxACL.EntryKey.deserialize((String)USER_1), MailboxACL.FULL_RIGHTS);
        Map foundEntries = result.getEntries();
        Assertions.assertThat((Map)foundEntries).isEqualTo(expectedEntries);
    }

    @Test
    void propertiesConstructorShouldAcceptNullValues() throws Exception {
        Assertions.assertThat((Object)new MailboxACL((Properties)null)).isEqualTo((Object)MailboxACL.EMPTY);
    }

    @Test
    void applyShouldNotThrowWhenRemovingANonExistingEntry() throws Exception {
        Assertions.assertThat((Object)MailboxACL.EMPTY.apply(MailboxACL.command().forUser(Username.of((String)"bob")).noRights().asReplacement())).isEqualTo((Object)MailboxACL.EMPTY);
    }

    @Test
    void usersACLShouldReturnEmptyMapWhenEmpty() {
        Assertions.assertThat((Map)MailboxACL.EMPTY.ofPositiveNameType(MailboxACL.NameType.user)).isEmpty();
    }

    @Test
    void usersACLShouldReturnEmptyMapWhenNoUserEntry() {
        MailboxACL mailboxACL = new MailboxACL((Map)ImmutableMap.of((Object)MailboxACL.EntryKey.createGroupEntryKey((String)"group"), (Object)MailboxACL.FULL_RIGHTS, (Object)MailboxACL.EntryKey.createGroupEntryKey((String)"group2"), (Object)MailboxACL.NO_RIGHTS));
        Assertions.assertThat((Map)mailboxACL.ofPositiveNameType(MailboxACL.NameType.user)).isEmpty();
    }

    @Test
    void usersACLShouldReturnOnlyUsersMapWhenSomeUserEntries() throws Exception {
        MailboxACL.Rfc4314Rights rights = MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"aei");
        MailboxACL mailboxACL = new MailboxACL((Map)ImmutableMap.of((Object)MailboxACL.EntryKey.createUserEntryKey((Username)USERNAME_1), (Object)MailboxACL.FULL_RIGHTS, (Object)MailboxACL.EntryKey.createGroupEntryKey((String)"group"), (Object)MailboxACL.FULL_RIGHTS, (Object)MailboxACL.EntryKey.createUserEntryKey((Username)USERNAME_2), (Object)rights, (Object)MailboxACL.EntryKey.createGroupEntryKey((String)"group2"), (Object)MailboxACL.NO_RIGHTS));
        Assertions.assertThat((Map)mailboxACL.ofPositiveNameType(MailboxACL.NameType.user)).containsOnly(new Map.Entry[]{MapEntry.entry((Object)MailboxACL.EntryKey.createUserEntryKey((Username)USERNAME_1), (Object)MailboxACL.FULL_RIGHTS), MapEntry.entry((Object)MailboxACL.EntryKey.createUserEntryKey((Username)USERNAME_2), (Object)rights)});
    }

    @Test
    void ofPositiveNameTypeShouldFilterOutNegativeEntries() throws Exception {
        MailboxACL mailboxACL = new MailboxACL((Map)ImmutableMap.of((Object)MailboxACL.EntryKey.createUserEntryKey((Username)Username.of((String)USER_1), (boolean)true), (Object)MailboxACL.FULL_RIGHTS));
        Assertions.assertThat((Map)mailboxACL.ofPositiveNameType(MailboxACL.NameType.user)).isEmpty();
    }
}

