/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MailboxAnnotationKeyTest {
    MailboxAnnotationKeyTest() {
    }

    @Test
    void newInstanceShouldThrowsExceptionWhenKeyDoesNotStartWithSlash() {
        Assertions.assertThatThrownBy(() -> new MailboxAnnotationKey("shared")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void newInstanceShouldThrowsExceptionWhenKeyContainsAsterisk() {
        Assertions.assertThatThrownBy(() -> new MailboxAnnotationKey("/private/key*comment")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void newInstanceShouldThrowsExceptionWhenKeyContainsPercent() {
        Assertions.assertThatThrownBy(() -> new MailboxAnnotationKey("/private/key%comment")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void validKeyShouldThrowsExceptionWhenKeyContainsTwoConsecutiveSlash() {
        Assertions.assertThatThrownBy(() -> new MailboxAnnotationKey("/private//keycomment")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void validKeyShouldThrowsExceptionWhenKeyEndsWithSlash() {
        Assertions.assertThatThrownBy(() -> new MailboxAnnotationKey("/private/keycomment/")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void validKeyShouldThrowsExceptionWhenKeyContainsNonASCII() {
        Assertions.assertThatThrownBy(() -> new MailboxAnnotationKey("/private/key\u252c\u00e1comment")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void validKeyShouldThrowsExceptionWhenKeyContainsTabCharacter() {
        Assertions.assertThatThrownBy(() -> new MailboxAnnotationKey("/private/key\tcomment")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void newInstanceShouldThrowsExceptionWithEmptyKey() {
        Assertions.assertThatThrownBy(() -> new MailboxAnnotationKey("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void newInstanceShouldThrowsExceptionWithBlankKey() {
        Assertions.assertThatThrownBy(() -> new MailboxAnnotationKey("    ")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void newInstanceShouldReturnRightKeyValue() {
        MailboxAnnotationKey annotationKey = new MailboxAnnotationKey("/private/comment");
        Assertions.assertThat((String)annotationKey.asString()).isEqualTo("/private/comment");
    }

    @Test
    void keyValueShouldBeCaseInsensitive() {
        MailboxAnnotationKey annotationKey = new MailboxAnnotationKey("/private/comment");
        MailboxAnnotationKey anotherAnnotationKey = new MailboxAnnotationKey("/PRIVATE/COMMENT");
        Assertions.assertThat((Object)annotationKey).isEqualTo((Object)anotherAnnotationKey);
    }

    @Test
    void newInstanceShouldThrowsExceptionWhenKeyContainsPunctuationCharacters() {
        Assertions.assertThatThrownBy(() -> new MailboxAnnotationKey("/private/+comment")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void countSlashShouldReturnRightNumberOfSlash() {
        MailboxAnnotationKey annotationKey = new MailboxAnnotationKey("/private/comment/user/name");
        Assertions.assertThat((int)annotationKey.countComponents()).isEqualTo(4);
    }

    @Test
    void keyMustContainAtLeastTwoComponents() {
        Assertions.assertThatThrownBy(() -> new MailboxAnnotationKey("/private")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void keyVendorShouldThrowsExceptionWithTwoComponents() {
        Assertions.assertThatThrownBy(() -> new MailboxAnnotationKey("/private/vendor")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void keyVendorShouldThrowsExceptionWithThreeComponents() {
        Assertions.assertThatThrownBy(() -> new MailboxAnnotationKey("/shared/vendor/token")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void keyVendorShouldOKWithFourComponents() {
        new MailboxAnnotationKey("/shared/vendor/token/comment");
    }

    @Test
    void isParentOrIsEqualShouldReturnTrueWhenSameKey() {
        MailboxAnnotationKey key1 = new MailboxAnnotationKey("/private/comment");
        Assertions.assertThat((boolean)key1.isParentOrIsEqual(key1)).isTrue();
    }

    @Test
    void isParentOrIsEqualShouldReturnTrueWhenParent() {
        MailboxAnnotationKey key1 = new MailboxAnnotationKey("/private/comment");
        MailboxAnnotationKey key2 = new MailboxAnnotationKey("/private/comment/toto");
        Assertions.assertThat((boolean)key1.isParentOrIsEqual(key2)).isTrue();
    }

    @Test
    void isParentOrIsEqualShouldReturnFalseWhenChild() {
        MailboxAnnotationKey key1 = new MailboxAnnotationKey("/private/comment");
        MailboxAnnotationKey key2 = new MailboxAnnotationKey("/private/comment/toto");
        Assertions.assertThat((boolean)key2.isParentOrIsEqual(key1)).isFalse();
    }

    @Test
    void isParentOrIsEqualShouldReturnFalseWhenGrandParent() {
        MailboxAnnotationKey key1 = new MailboxAnnotationKey("/private/comment");
        MailboxAnnotationKey key2 = new MailboxAnnotationKey("/private/comment/toto/tata");
        Assertions.assertThat((boolean)key1.isParentOrIsEqual(key2)).isFalse();
    }

    @Test
    void isParentOrIsEqualShouldReturnFalseWhenCousin() {
        MailboxAnnotationKey key1 = new MailboxAnnotationKey("/private/comment/tutu");
        MailboxAnnotationKey key2 = new MailboxAnnotationKey("/private/comment/toto/tata");
        Assertions.assertThat((boolean)key1.isParentOrIsEqual(key2)).isFalse();
    }

    @Test
    void isAncestorOrIsEqualShouldReturnTrueWhenSameKey() {
        MailboxAnnotationKey key1 = new MailboxAnnotationKey("/private/comment");
        Assertions.assertThat((boolean)key1.isAncestorOrIsEqual(key1)).isTrue();
    }

    @Test
    void isAncestorOrIsEqualShouldReturnTrueWhenParent() {
        MailboxAnnotationKey key1 = new MailboxAnnotationKey("/private/comment");
        MailboxAnnotationKey key2 = new MailboxAnnotationKey("/private/comment/toto");
        Assertions.assertThat((boolean)key1.isAncestorOrIsEqual(key2)).isTrue();
    }

    @Test
    void isAncestorOrIsEqualShouldReturnFalseWhenChild() {
        MailboxAnnotationKey key1 = new MailboxAnnotationKey("/private/comment");
        MailboxAnnotationKey key2 = new MailboxAnnotationKey("/private/comment/toto");
        Assertions.assertThat((boolean)key2.isAncestorOrIsEqual(key1)).isFalse();
    }

    @Test
    void isAncestorOrIsEqualShouldReturnTrueWhenGrandParent() {
        MailboxAnnotationKey key1 = new MailboxAnnotationKey("/private/comment");
        MailboxAnnotationKey key2 = new MailboxAnnotationKey("/private/comment/toto/tata");
        Assertions.assertThat((boolean)key1.isAncestorOrIsEqual(key2)).isTrue();
    }

    @Test
    void isAncestorOrIsEqualShouldReturnFalseWhenCousin() {
        MailboxAnnotationKey key1 = new MailboxAnnotationKey("/private/comment/tutu");
        MailboxAnnotationKey key2 = new MailboxAnnotationKey("/private/comment/toto/tata");
        Assertions.assertThat((boolean)key1.isAncestorOrIsEqual(key2)).isFalse();
    }

    @Test
    void isAncestorOrIsEqualShouldWorkOnCousinKeyUsingKeyAsAPrefix() {
        MailboxAnnotationKey key1 = new MailboxAnnotationKey("/private/comment/tutu");
        MailboxAnnotationKey key2 = new MailboxAnnotationKey("/private/comment/tututata");
        Assertions.assertThat((boolean)key1.isAncestorOrIsEqual(key2)).isFalse();
    }

    @Test
    void isParentOrIsEqualShouldWorkOnCousinKeyUsingKeyAsAPrefix() {
        MailboxAnnotationKey key1 = new MailboxAnnotationKey("/private/comment/tutu");
        MailboxAnnotationKey key2 = new MailboxAnnotationKey("/private/comment/tututata");
        Assertions.assertThat((boolean)key1.isParentOrIsEqual(key2)).isFalse();
    }
}

