/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.Map;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxAssertingTool;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.mailbox.model.UidValidity;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class MailboxAssertingToolTest {
    private static final Username USER = Username.of((String)"user");
    private static final Username USER1 = Username.of((String)"user1");
    private static final UidValidity UID_VALIDITY = UidValidity.of((long)42L);
    private static final UidValidity UID_VALIDITY_2 = UidValidity.of((long)43L);
    private static final TestId MAILBOX_ID = TestId.of(24L);

    MailboxAssertingToolTest() {
    }

    @Nested
    class MailboxSoftlyAssertTest {
        MailboxSoftlyAssertTest() {
        }

        @Test
        void isEqualToShouldNotFailWithEqualMailbox() {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            SoftAssertions.assertSoftly(softly -> MailboxAssertingTool.softly(softly).assertThat(mailbox1).isEqualTo(mailbox2));
        }

        @Test
        void isEqualToShouldFailWithNotEqualNamespace() {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(new MailboxPath("other_namespace", USER, "name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SoftAssertions.assertSoftly(softly -> MailboxAssertingTool.softly(softly).assertThat(mailbox1).isEqualTo(mailbox2))).isInstanceOf(AssertionError.class)).hasMessageContaining("Expected NameSpace to be <other_namespace> but was <#private>");
        }

        @Test
        void isEqualToShouldFailWithNotEqualName() {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"other_name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SoftAssertions.assertSoftly(softly -> MailboxAssertingTool.softly(softly).assertThat(mailbox1).isEqualTo(mailbox2))).isInstanceOf(AssertionError.class)).hasMessageContaining("Expected Name to be <other_name> but was <name>");
        }

        @Test
        void isEqualToShouldFailWithNotEqualId() {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)TestId.of(MailboxAssertingToolTest.MAILBOX_ID.id + 1L));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SoftAssertions.assertSoftly(softly -> MailboxAssertingTool.softly(softly).assertThat(mailbox1).isEqualTo(mailbox2))).isInstanceOf(AssertionError.class)).hasMessageContaining("Expected MailboxId to be <TestId{id=25}> but was <TestId{id=24}>");
        }

        @Test
        void isEqualToShouldFailWithNotEqualUidValidity() {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY_2, (MailboxId)MAILBOX_ID);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SoftAssertions.assertSoftly(softly -> MailboxAssertingTool.softly(softly).assertThat(mailbox1).isEqualTo(mailbox2))).isInstanceOf(AssertionError.class)).hasMessageContaining("Expected UID Validity to be <UidValidity{uidValidity=43}> but was <UidValidity{uidValidity=42}");
        }

        @Test
        void isEqualToShouldFailWithNotSameSizeEntries() throws Exception {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            mailbox1.setACL(new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(USER.asString(), new MailboxACL.Right[]{MailboxACL.Right.Write})}));
            mailbox2.setACL(new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(USER.asString(), new MailboxACL.Right[]{MailboxACL.Right.Write}), new MailboxACL.Entry(USER1.asString(), new MailboxACL.Right[]{MailboxACL.Right.Read})}));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SoftAssertions.assertSoftly(softly -> MailboxAssertingTool.softly(softly).assertThat(mailbox1).isEqualTo(mailbox2))).isInstanceOf(AssertionError.class)).hasMessageContaining("Expected ACL to be <MailboxACL{entries={user=w, user1=r}}> but was <MailboxACL{entries={user=w}}");
        }

        @Test
        void isEqualToShouldFailWithSameSizeButDifferentEntries() throws Exception {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            mailbox1.setACL(new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(USER.asString(), new MailboxACL.Right[]{MailboxACL.Right.Write})}));
            mailbox2.setACL(new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(USER1.asString(), new MailboxACL.Right[]{MailboxACL.Right.Read})}));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SoftAssertions.assertSoftly(softly -> MailboxAssertingTool.softly(softly).assertThat(mailbox1).isEqualTo(mailbox2))).isInstanceOf(AssertionError.class)).hasMessageContaining("Expected ACL to be <MailboxACL{entries={user1=r}}> but was <MailboxACL{entries={user=w}}");
        }

        @Test
        void isEqualToShouldPassWithSameSizeEntriesButDifferentOrder() throws Exception {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            mailbox1.setACL(new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(USER1.asString(), new MailboxACL.Right[]{MailboxACL.Right.Read}), new MailboxACL.Entry(USER.asString(), new MailboxACL.Right[]{MailboxACL.Right.Write})}));
            mailbox2.setACL(new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(USER.asString(), new MailboxACL.Right[]{MailboxACL.Right.Write}), new MailboxACL.Entry(USER1.asString(), new MailboxACL.Right[]{MailboxACL.Right.Read})}));
            SoftAssertions.assertSoftly(softly -> MailboxAssertingTool.softly(softly).assertThat(mailbox1).isEqualTo(mailbox2));
        }
    }

    @Nested
    class MailboxAssertTest {
        MailboxAssertTest() {
        }

        @Test
        void isEqualToShouldNotFailWithEqualMailbox() {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            MailboxAssertingTool.assertThat(mailbox1).isEqualTo(mailbox2);
        }

        @Test
        void isEqualToShouldFailWithNotEqualNamespace() {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(new MailboxPath("other_namespace", USER, "name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Assertions.assertThatThrownBy(() -> MailboxAssertingTool.assertThat(mailbox1).isEqualTo(mailbox2)).isInstanceOf(AssertionError.class);
        }

        @Test
        void isEqualToShouldFailWithNotEqualUser() {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(new MailboxPath("namespace", Username.of((String)"other_user"), "name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Assertions.assertThatThrownBy(() -> MailboxAssertingTool.assertThat(mailbox1).isEqualTo(mailbox2)).isInstanceOf(AssertionError.class);
        }

        @Test
        void isEqualToShouldFailWithNotEqualName() {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(new MailboxPath("namespace", USER, "other_name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Assertions.assertThatThrownBy(() -> MailboxAssertingTool.assertThat(mailbox1).isEqualTo(mailbox2)).isInstanceOf(AssertionError.class);
        }

        @Test
        void isEqualToShouldFailWithNotEqualId() {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)TestId.of(MailboxAssertingToolTest.MAILBOX_ID.id + 1L));
            Assertions.assertThatThrownBy(() -> MailboxAssertingTool.assertThat(mailbox1).isEqualTo(mailbox2)).isInstanceOf(AssertionError.class);
        }

        @Test
        void isEqualToShouldFailWithNotEqualUidValidity() {
            Mailbox mailbox1 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY, (MailboxId)MAILBOX_ID);
            Mailbox mailbox2 = new Mailbox(MailboxPath.forUser((Username)USER, (String)"name"), UID_VALIDITY_2, (MailboxId)MAILBOX_ID);
            Assertions.assertThatThrownBy(() -> MailboxAssertingTool.assertThat(mailbox1).isEqualTo(mailbox2)).isInstanceOf(AssertionError.class);
        }
    }
}

