/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.TestId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MailboxCountersTest {
    public static final TestId MAILBOX_ID = TestId.of(36L);

    MailboxCountersTest() {
    }

    @Test
    void mailboxCountersShouldRespectBeanContract() {
        EqualsVerifier.forClass(MailboxCounters.class).verify();
    }

    @Test
    void sanitizeShouldCorrectNegativeCount() {
        Assertions.assertThat((Object)MailboxCounters.builder().mailboxId((MailboxId)MAILBOX_ID).count(-1L).unseen(0L).build().sanitize()).isEqualTo((Object)MailboxCounters.empty((MailboxId)MAILBOX_ID));
    }

    @Test
    void sanitizeShouldCorrectNegativeUnseen() {
        Assertions.assertThat((Object)MailboxCounters.builder().mailboxId((MailboxId)MAILBOX_ID).count(12L).unseen(-1L).build().sanitize()).isEqualTo((Object)MailboxCounters.builder().mailboxId((MailboxId)MAILBOX_ID).count(12L).unseen(0L).build());
    }

    @Test
    void sanitizeShouldCorrectUnseenExceedingCount() {
        Assertions.assertThat((Object)MailboxCounters.builder().mailboxId((MailboxId)MAILBOX_ID).count(12L).unseen(36L).build().sanitize()).isEqualTo((Object)MailboxCounters.builder().mailboxId((MailboxId)MAILBOX_ID).count(12L).unseen(12L).build());
    }

    @Test
    void sanitizeShouldNoopWhenValid() {
        Assertions.assertThat((Object)MailboxCounters.builder().mailboxId((MailboxId)MAILBOX_ID).count(36L).unseen(12L).build().sanitize()).isEqualTo((Object)MailboxCounters.builder().mailboxId((MailboxId)MAILBOX_ID).count(36L).unseen(12L).build());
    }
}

