/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageIdDto;
import org.apache.james.mailbox.model.TestMessageId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MessageIdDtoTest {
    private static final TestMessageId.Factory factory = new TestMessageId.Factory();
    private static final Long SAMPLE_ID_VALUE = 42L;
    private static final String SAMPLE_ID_STRING = SAMPLE_ID_VALUE.toString();
    private static final TestMessageId SAMPLE_ID = TestMessageId.of(SAMPLE_ID_VALUE);

    MessageIdDtoTest() {
    }

    @Test
    void shouldRespectJavaBeanContract() {
        EqualsVerifier.forClass(MessageIdDto.class).verify();
    }

    @Test
    void shouldAcceptStringAndGiveItBack() {
        Assertions.assertThat((String)new MessageIdDto(SAMPLE_ID_STRING).asString()).isEqualTo(SAMPLE_ID_STRING);
    }

    @Test
    void shouldAcceptMessageIdAndGiveTheRightString() {
        Assertions.assertThat((String)new MessageIdDto((MessageId)SAMPLE_ID).asString()).isEqualTo(SAMPLE_ID_STRING);
    }

    @Test
    void shouldAcceptMessageIdAndGiveItBack() {
        Assertions.assertThat((Object)new MessageIdDto((MessageId)SAMPLE_ID).instantiate((MessageId.Factory)factory)).isEqualTo((Object)SAMPLE_ID);
    }

    @Test
    void shouldAcceptStringAndGiveAnInstantiatedMessageId() {
        Assertions.assertThat((Object)new MessageIdDto(SAMPLE_ID_STRING).instantiate((MessageId.Factory)factory)).isEqualTo((Object)SAMPLE_ID);
    }

    @Test
    void shouldThrowAnExceptionOnWronglyFormattedString() {
        MessageIdDto messageIdDto = new MessageIdDto("Definitively not a number");
        Assertions.assertThatThrownBy(() -> messageIdDto.instantiate((MessageId.Factory)factory)).isInstanceOf(Exception.class);
    }
}

