/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import javax.mail.Flags;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class UpdatedFlagsTest {
    public static final MessageUid UID = MessageUid.of((long)45L);
    public static final ModSeq MOD_SEQ = ModSeq.of((long)47L);

    UpdatedFlagsTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(UpdatedFlags.class).withIgnoredFields(new String[]{"modifiedFlags"}).verify();
    }

    @Test
    void isModifiedToSetShouldReturnTrueWhenFlagOnlyInNewFlag() {
        UpdatedFlags updatedFlags = UpdatedFlags.builder().newFlags(new Flags(Flags.Flag.RECENT)).oldFlags(new Flags()).uid(UID).modSeq(MOD_SEQ).build();
        Assertions.assertThat((boolean)updatedFlags.isModifiedToSet(Flags.Flag.RECENT)).isTrue();
    }

    @Test
    void isModifiedToSetShouldReturnFalseWhenFlagOnlyInOldFlag() {
        UpdatedFlags updatedFlags = UpdatedFlags.builder().newFlags(new Flags()).oldFlags(new Flags(Flags.Flag.RECENT)).uid(UID).modSeq(MOD_SEQ).build();
        Assertions.assertThat((boolean)updatedFlags.isModifiedToSet(Flags.Flag.RECENT)).isFalse();
    }

    @Test
    void isModifiedToSetShouldReturnFalseWhenFlagIsOnNone() {
        UpdatedFlags updatedFlags = UpdatedFlags.builder().newFlags(new Flags()).oldFlags(new Flags()).uid(UID).modSeq(MOD_SEQ).build();
        Assertions.assertThat((boolean)updatedFlags.isModifiedToSet(Flags.Flag.RECENT)).isFalse();
    }

    @Test
    void isModifiedToSetShouldReturnFalseWhenFlagIsOnBoth() {
        UpdatedFlags updatedFlags = UpdatedFlags.builder().newFlags(new Flags(Flags.Flag.RECENT)).oldFlags(new Flags(Flags.Flag.RECENT)).uid(UID).modSeq(MOD_SEQ).build();
        Assertions.assertThat((boolean)updatedFlags.isModifiedToSet(Flags.Flag.RECENT)).isFalse();
    }

    @Test
    void isModifiedToUnsetShouldReturnFalseWhenFlagOnlyInNewFlag() {
        UpdatedFlags updatedFlags = UpdatedFlags.builder().newFlags(new Flags(Flags.Flag.RECENT)).oldFlags(new Flags()).uid(UID).modSeq(MOD_SEQ).build();
        Assertions.assertThat((boolean)updatedFlags.isModifiedToUnset(Flags.Flag.RECENT)).isFalse();
    }

    @Test
    void isModifiedToUnsetShouldReturnTrueWhenFlagOnlyInOldFlag() {
        UpdatedFlags updatedFlags = UpdatedFlags.builder().newFlags(new Flags()).oldFlags(new Flags(Flags.Flag.RECENT)).uid(UID).modSeq(MOD_SEQ).build();
        Assertions.assertThat((boolean)updatedFlags.isModifiedToUnset(Flags.Flag.RECENT)).isTrue();
    }

    @Test
    void isModifiedToUnsetShouldReturnFalseWhenFlagIsOnNone() {
        UpdatedFlags updatedFlags = UpdatedFlags.builder().newFlags(new Flags()).oldFlags(new Flags()).uid(UID).modSeq(MOD_SEQ).build();
        Assertions.assertThat((boolean)updatedFlags.isModifiedToSet(Flags.Flag.RECENT)).isFalse();
    }

    @Test
    void isModifiedToUnsetShouldReturnFalseWhenFlagIsOnBoth() {
        UpdatedFlags updatedFlags = UpdatedFlags.builder().newFlags(new Flags(Flags.Flag.RECENT)).oldFlags(new Flags(Flags.Flag.RECENT)).uid(UID).modSeq(MOD_SEQ).build();
        Assertions.assertThat((boolean)updatedFlags.isModifiedToUnset(Flags.Flag.RECENT)).isFalse();
    }

    @Test
    void isUnchangedShouldReturnFalseWhenFlagOnlyInNewFlag() {
        UpdatedFlags updatedFlags = UpdatedFlags.builder().newFlags(new Flags(Flags.Flag.RECENT)).oldFlags(new Flags()).uid(UID).modSeq(MOD_SEQ).build();
        Assertions.assertThat((boolean)updatedFlags.isUnchanged(Flags.Flag.RECENT)).isFalse();
    }

    @Test
    void isUnchangedShouldReturnFalseWhenFlagOnlyInOldFlag() {
        UpdatedFlags updatedFlags = UpdatedFlags.builder().newFlags(new Flags()).oldFlags(new Flags(Flags.Flag.RECENT)).uid(UID).modSeq(MOD_SEQ).build();
        Assertions.assertThat((boolean)updatedFlags.isUnchanged(Flags.Flag.RECENT)).isFalse();
    }

    @Test
    void isUnchangedShouldReturnTrueWhenFlagIsOnNone() {
        UpdatedFlags updatedFlags = UpdatedFlags.builder().newFlags(new Flags()).oldFlags(new Flags()).uid(UID).modSeq(MOD_SEQ).build();
        Assertions.assertThat((boolean)updatedFlags.isUnchanged(Flags.Flag.RECENT)).isTrue();
    }

    @Test
    void isUnchangedShouldReturnTrueWhenFlagIsOnBoth() {
        UpdatedFlags updatedFlags = UpdatedFlags.builder().newFlags(new Flags(Flags.Flag.RECENT)).oldFlags(new Flags(Flags.Flag.RECENT)).uid(UID).modSeq(MOD_SEQ).build();
        Assertions.assertThat((boolean)updatedFlags.isUnchanged(Flags.Flag.RECENT)).isTrue();
    }
}

