/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model.search;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.model.search.ExactName;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExactNameTest {
    public static final String NAME = "toto";

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(ExactName.class).verify();
    }

    @Test
    void constructorShouldThrowOnNullName() {
        Assertions.assertThatThrownBy(() -> new ExactName(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void isWildShouldReturnFalse() {
        Assertions.assertThat((boolean)new ExactName(NAME).isWild()).isFalse();
    }

    @Test
    void getCombinedNameShouldReturnName() {
        Assertions.assertThat((String)new ExactName(NAME).getCombinedName()).isEqualTo(NAME);
    }

    @Test
    void isExpressionMatchShouldReturnTrueWhenName() {
        Assertions.assertThat((boolean)new ExactName(NAME).isExpressionMatch(NAME)).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenOtherValue() {
        Assertions.assertThat((boolean)new ExactName(NAME).isExpressionMatch("other")).isFalse();
    }

    @Test
    void isExpressionMatchShouldThrowOnNullValue() {
        Assertions.assertThatThrownBy(() -> new ExactName(NAME).isExpressionMatch(null)).isInstanceOf(NullPointerException.class);
    }
}

