/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model.search;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.ExactName;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.Wildcard;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MailboxQueryTest {
    private static final Username CURRENT_USER = Username.of((String)"user");
    private MailboxPath mailboxPath;

    MailboxQueryTest() {
    }

    @BeforeEach
    void setUp() {
        this.mailboxPath = new MailboxPath("namespace", CURRENT_USER, "name");
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(MailboxQuery.class).verify();
    }

    @Test
    void buildShouldMatchAllValuesWhenMatchesAll() {
        MailboxQuery actual = MailboxQuery.builder().userAndNamespaceFrom(this.mailboxPath).matchesAllMailboxNames().build();
        Assertions.assertThat((boolean)actual.isExpressionMatch("folder")).isTrue();
    }

    @Test
    void buildShouldConstructMailboxPathWhenPrivateUserMailboxes() {
        MailboxPath expected = MailboxPath.forUser((Username)CURRENT_USER, (String)"");
        MailboxQuery actual = MailboxQuery.builder().username(CURRENT_USER).privateNamespace().build();
        Assertions.assertThat((Optional)actual.getNamespace()).contains((Object)expected.getNamespace());
        Assertions.assertThat((Optional)actual.getUser()).contains((Object)expected.getUser());
        Assertions.assertThat((Object)actual.getMailboxNameExpression()).isEqualTo((Object)Wildcard.INSTANCE);
    }

    @Test
    void buildShouldMatchAllValuesWhenPrivateUserMailboxes() {
        MailboxQuery.Builder testee = MailboxQuery.builder().username(CURRENT_USER).privateNamespace();
        MailboxQuery actual = testee.build();
        Assertions.assertThat((boolean)actual.isExpressionMatch("folder")).isTrue();
    }

    @Test
    void builderShouldNotThrowWhenNoBaseDefined() {
        MailboxQuery.Builder testee = MailboxQuery.builder().expression((MailboxNameExpression)new ExactName("abc"));
        Assertions.assertThatCode(() -> ((MailboxQuery.Builder)testee).build()).doesNotThrowAnyException();
    }

    @Test
    void builderShouldThrowWhenBaseAndUsernameGiven() {
        Assertions.assertThatThrownBy(() -> MailboxQuery.builder().userAndNamespaceFrom(this.mailboxPath).username(CURRENT_USER)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void builderShouldThrowWhenBaseGiven() {
        Assertions.assertThatThrownBy(() -> MailboxQuery.builder().userAndNamespaceFrom(this.mailboxPath).privateNamespace()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void builderShouldNotThrowWhenMissingUsername() {
        MailboxQuery.Builder testee = MailboxQuery.builder().privateNamespace();
        Assertions.assertThatCode(() -> ((MailboxQuery.Builder)testee).build()).doesNotThrowAnyException();
    }

    @Test
    void builderShouldUseBaseWhenGiven() {
        MailboxQuery actual = MailboxQuery.builder().userAndNamespaceFrom(this.mailboxPath).build();
        Assertions.assertThat((Optional)actual.getNamespace()).contains((Object)this.mailboxPath.getNamespace());
        Assertions.assertThat((Optional)actual.getUser()).contains((Object)this.mailboxPath.getUser());
        Assertions.assertThat((Object)actual.getMailboxNameExpression()).isEqualTo((Object)Wildcard.INSTANCE);
    }

    @Test
    void belongsToNamespaceAndUserShouldReturnTrueWithIdenticalMailboxes() {
        MailboxQuery mailboxQuery = MailboxQuery.builder().userAndNamespaceFrom(this.mailboxPath).build();
        Assertions.assertThat((boolean)mailboxQuery.belongsToRequestedNamespaceAndUser(this.mailboxPath)).isTrue();
    }

    @Test
    void belongsToNamespaceAndUserShouldReturnTrueWithIdenticalMailboxesWithNullNamespace() {
        MailboxPath mailboxPath = new MailboxPath(null, CURRENT_USER, "name");
        MailboxQuery mailboxQuery = MailboxQuery.builder().userAndNamespaceFrom(mailboxPath).build();
        Assertions.assertThat((boolean)mailboxQuery.belongsToRequestedNamespaceAndUser(mailboxPath)).isTrue();
    }

    @Test
    void belongsToNamespaceAndUserShouldReturnTrueWithMailboxWithSameNamespaceAndUser() {
        MailboxQuery mailboxQuery = MailboxQuery.builder().userAndNamespaceFrom(new MailboxPath("namespace", CURRENT_USER, "name")).build();
        Assertions.assertThat((boolean)mailboxQuery.belongsToRequestedNamespaceAndUser(new MailboxPath("namespace", CURRENT_USER, "name2"))).isTrue();
    }

    @Test
    void belongsToNamespaceAndUserShouldReturnFalseWithDifferentNamespace() {
        MailboxQuery mailboxQuery = MailboxQuery.builder().userAndNamespaceFrom(new MailboxPath("namespace", CURRENT_USER, "name")).build();
        Assertions.assertThat((boolean)mailboxQuery.belongsToRequestedNamespaceAndUser(new MailboxPath("namespace2", CURRENT_USER, "name"))).isFalse();
    }

    @Test
    void belongsToNamespaceAndUserShouldReturnFalseWithDifferentUser() {
        MailboxQuery mailboxQuery = MailboxQuery.builder().userAndNamespaceFrom(new MailboxPath("namespace", CURRENT_USER, "name")).build();
        Assertions.assertThat((boolean)mailboxQuery.belongsToRequestedNamespaceAndUser(new MailboxPath("namespace", Username.of((String)"user2"), "name"))).isFalse();
    }

    @Test
    void belongsToNamespaceAndUserShouldReturnFalseWhenDifferentUser() {
        MailboxQuery mailboxQuery = MailboxQuery.builder().userAndNamespaceFrom(new MailboxPath("namespace", CURRENT_USER, "name")).build();
        Assertions.assertThat((boolean)mailboxQuery.belongsToRequestedNamespaceAndUser(new MailboxPath("namespace", Username.of((String)"other"), "name"))).isFalse();
    }
}

