/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model.search;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.model.search.PrefixedWildcard;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PrefixedWildcardTest {
    public static final String NAME = "toto";

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(PrefixedWildcard.class).verify();
    }

    @Test
    void constructorShouldThrowOnNullName() {
        Assertions.assertThatThrownBy(() -> new PrefixedWildcard(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void isWildShouldReturnTrue() {
        Assertions.assertThat((boolean)new PrefixedWildcard(NAME).isWild()).isTrue();
    }

    @Test
    void getCombinedNameShouldReturnName() {
        Assertions.assertThat((String)new PrefixedWildcard(NAME).getCombinedName()).isEqualTo("toto*");
    }

    @Test
    void isExpressionMatchShouldReturnTrueWhenName() {
        Assertions.assertThat((boolean)new PrefixedWildcard(NAME).isExpressionMatch(NAME)).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnTrueWhenNameAndPostfix() {
        Assertions.assertThat((boolean)new PrefixedWildcard(NAME).isExpressionMatch("totoany")).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenOtherValue() {
        Assertions.assertThat((boolean)new PrefixedWildcard(NAME).isExpressionMatch("other")).isFalse();
    }

    @Test
    void isExpressionMatchShouldThrowOnNullValue() {
        Assertions.assertThatThrownBy(() -> new PrefixedWildcard(NAME).isExpressionMatch(null)).isInstanceOf(NullPointerException.class);
    }
}

