/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.mail.Flags;
import org.apache.james.mailbox.ApplicableFlagBuilder;
import org.apache.james.mailbox.FlagsBuilder;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class ApplicableFlagBuilderTest {
    ApplicableFlagBuilderTest() {
    }

    @Test
    void shouldAtLeastContainAllDefaultApplicativeFlag() {
        Assertions.assertThat((Object)ApplicableFlagBuilder.builder().build()).isEqualTo((Object)ApplicableFlagBuilder.DEFAULT_APPLICABLE_FLAGS);
    }

    @Test
    void shouldNeverRetainRecentAndUserFlag() {
        Flags result = ApplicableFlagBuilder.builder().add(new Flags[]{new Flags(Flags.Flag.RECENT)}).add(new Flags[]{new Flags(Flags.Flag.USER)}).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(result.contains(Flags.Flag.RECENT)).isFalse();
            softly.assertThat(result.contains(Flags.Flag.USER)).isFalse();
        });
    }

    @Test
    void shouldAddCustomUserFlagIfProvidedToDefaultFlag() {
        Flags result = ApplicableFlagBuilder.builder().add(new String[]{"yolo", "vibe"}).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(result.contains(ApplicableFlagBuilder.DEFAULT_APPLICABLE_FLAGS)).isTrue();
            softly.assertThat(result.contains("yolo")).isTrue();
            softly.assertThat(result.contains("vibe")).isTrue();
        });
    }

    @Test
    void shouldAcceptUserCustomFlagInsideFlags() {
        Flags result = ApplicableFlagBuilder.builder().add(new Flags[]{new Flags("yolo")}).build();
        Assertions.assertThat((boolean)result.contains("yolo")).isTrue();
    }

    @Test
    void shouldAcceptFlagsThatContainMultipleFlag() {
        Flags flags = FlagsBuilder.builder().add(new String[]{"yolo", "vibes"}).build();
        Flags result = ApplicableFlagBuilder.builder().add(new Flags[]{flags}).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(result.contains("yolo")).isTrue();
            softly.assertThat(result.contains("vibes")).isTrue();
        });
    }

    @Test
    void addShouldAddMultipleFlagsAtOnce() {
        Flags flags = new Flags("cartman");
        Flags flags2 = new Flags("butters");
        Flags result = ApplicableFlagBuilder.builder().add(new Flags[]{flags, flags2}).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(result.contains(flags)).isTrue();
            softly.assertThat(result.contains(flags2)).isTrue();
        });
    }

    @Test
    void shouldAcceptMultipleFlagAtOnce() {
        Flags result = ApplicableFlagBuilder.builder().add(new String[]{"cartman", "butters"}).add(new String[]{"chef", "randy"}).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(result.contains("cartman")).isTrue();
            softly.assertThat(result.contains("butters")).isTrue();
            softly.assertThat(result.contains("chef")).isTrue();
            softly.assertThat(result.contains("randy")).isTrue();
        });
    }

    @Test
    void shouldAcceptListOfFlags() throws Exception {
        Flags result = ApplicableFlagBuilder.builder().add((List)ImmutableList.of((Object)new Flags("cartman"), (Object)new Flags("chef"))).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(result.contains("cartman")).isTrue();
            softly.assertThat(result.contains("chef")).isTrue();
        });
    }
}

