/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MailboxSessionUtil;
import org.apache.james.mailbox.events.MessageMoveEvent;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMoves;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.mailbox.model.TestMessageId;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class MessageMoveEventTest {
    private static final Username USER = Username.of((String)"user@james.org");

    MessageMoveEventTest() {
    }

    @Test
    void shouldRespectBeanContract() {
        EqualsVerifier.forClass(MessageMoveEvent.class).verify();
    }

    @Test
    void builderShouldThrowWhenSessionIsNull() {
        Assertions.assertThatThrownBy(() -> MessageMoveEvent.builder().build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void builderShouldThrowWhenMessageMovesIsNull() {
        Assertions.assertThatThrownBy(() -> MessageMoveEvent.builder().session(MailboxSessionUtil.create(USER)).build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void builderShouldReturnNoopWhenMessagesIsEmpty() {
        Assertions.assertThat((boolean)MessageMoveEvent.builder().session(MailboxSessionUtil.create(USER)).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{TestId.of(1L)}).targetMailboxIds(new MailboxId[]{TestId.of(2L)}).build()).build().isNoop()).isTrue();
    }

    @Test
    void builderShouldNotBeNoopWhenFieldsAreGiven() {
        MailboxSession session = MailboxSessionUtil.create(USER);
        MessageMoves messageMoves = MessageMoves.builder().targetMailboxIds(new MailboxId[]{TestId.of(2L)}).previousMailboxIds(new MailboxId[]{TestId.of(1L)}).build();
        MessageMoveEvent event = MessageMoveEvent.builder().session(session).messageMoves(messageMoves).messageId((MessageId)TestMessageId.of(35L)).build();
        Assertions.assertThat((boolean)event.isNoop()).isFalse();
    }

    @Test
    void builderShouldBuildWhenFieldsAreGiven() {
        MailboxSession session = MailboxSessionUtil.create(USER);
        MessageMoves messageMoves = MessageMoves.builder().targetMailboxIds(new MailboxId[]{TestId.of(2L)}).previousMailboxIds(new MailboxId[]{TestId.of(1L)}).build();
        TestMessageId messageId = TestMessageId.of(45L);
        MessageMoveEvent event = MessageMoveEvent.builder().session(session).messageMoves(messageMoves).messageId((MessageId)messageId).build();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Object)event.getUsername()).isEqualTo((Object)USER);
            softly.assertThat((Object)event.getMessageMoves()).isEqualTo((Object)messageMoves);
            softly.assertThat(event.getMessageIds()).containsExactly((Object[])new MessageId[]{messageId});
        });
    }

    @Test
    void isMoveToShouldReturnFalseWhenMailboxIdIsNotInAddedMailboxIds() {
        MessageMoveEvent event = MessageMoveEvent.builder().session(MailboxSessionUtil.create(USER)).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{TestId.of(1L)}).targetMailboxIds(new MailboxId[]{TestId.of(2L)}).build()).build();
        Assertions.assertThat((boolean)event.isMoveTo((MailboxId)TestId.of(123L))).isFalse();
    }

    @Test
    void isMoveToShouldReturnTrueWhenMailboxIdIsInAddedMailboxIds() {
        TestId mailboxId = TestId.of(123L);
        MessageMoveEvent event = MessageMoveEvent.builder().session(MailboxSessionUtil.create(USER)).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{TestId.of(1L)}).targetMailboxIds(new MailboxId[]{TestId.of(2L), mailboxId}).build()).build();
        Assertions.assertThat((boolean)event.isMoveTo((MailboxId)mailboxId)).isTrue();
    }

    @Test
    void isMoveFromShouldReturnFalseWhenMailboxIdIsNotInRemovedMailboxIds() {
        MessageMoveEvent event = MessageMoveEvent.builder().session(MailboxSessionUtil.create(USER)).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{TestId.of(1L)}).targetMailboxIds(new MailboxId[]{TestId.of(2L)}).build()).build();
        Assertions.assertThat((boolean)event.isMoveFrom((MailboxId)TestId.of(123L))).isFalse();
    }

    @Test
    void isMoveFromShouldReturnTrueWhenMailboxIdIsInRemovedMailboxIds() {
        TestId mailboxId = TestId.of(123L);
        MessageMoveEvent event = MessageMoveEvent.builder().session(MailboxSessionUtil.create(USER)).messageMoves(MessageMoves.builder().previousMailboxIds(new MailboxId[]{TestId.of(1L), mailboxId}).targetMailboxIds(new MailboxId[]{TestId.of(2L)}).build()).build();
        Assertions.assertThat((boolean)event.isMoveFrom((MailboxId)mailboxId)).isTrue();
    }
}

