/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.util.Locale;
import java.util.Optional;
import org.apache.james.mailbox.Role;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RoleTest {
    RoleTest() {
    }

    @Test
    void fromShouldReturnEmptyWhenUnknownValue() {
        Assertions.assertThat((Optional)Role.from((String)"jjjj")).isEqualTo(Optional.empty());
    }

    @Test
    void fromShouldReturnSomethingWhenXPrefixedRole() {
        Assertions.assertThat((Optional)Role.from((String)"x-client-specific-role")).isEqualTo(Optional.of(new Role("x-client-specific-role")));
    }

    @Test
    void isSystemRoleShouldReturnFalseWhenXPrefixedRole() {
        Role role = (Role)Role.from((String)"x-client-specific-role").get();
        Assertions.assertThat((boolean)role.isSystemRole()).isFalse();
    }

    @Test
    void fromShouldReturnInboxWhenContainsUppercaseValueInTurkish() {
        Locale previousLocale = Locale.getDefault();
        Locale.setDefault(Locale.forLanguageTag("tr"));
        try {
            Assertions.assertThat((Optional)Role.from((String)"InBox")).isEqualTo(Optional.of(Role.INBOX));
        }
        finally {
            Locale.setDefault(previousLocale);
        }
    }

    @Test
    void isSystemRoleShouldBeTrueWhenInbox() {
        Assertions.assertThat((boolean)Role.INBOX.isSystemRole()).isTrue();
    }

    @Test
    void isSystemRoleShouldBeTrueWhenArchive() {
        Assertions.assertThat((boolean)Role.ARCHIVE.isSystemRole()).isTrue();
    }

    @Test
    void isSystemRoleShouldBeTrueWhenDrafts() {
        Assertions.assertThat((boolean)Role.DRAFTS.isSystemRole()).isTrue();
    }

    @Test
    void isSystemRoleShouldBeTrueWhenOutbox() {
        Assertions.assertThat((boolean)Role.OUTBOX.isSystemRole()).isTrue();
    }

    @Test
    void isSystemRoleShouldBeTrueWhenSent() {
        Assertions.assertThat((boolean)Role.SENT.isSystemRole()).isTrue();
    }

    @Test
    void isSystemRoleShouldBeTrueWhenTrash() {
        Assertions.assertThat((boolean)Role.TRASH.isSystemRole()).isTrue();
    }

    @Test
    void isSystemRoleShouldBeTrueWhenSpam() {
        Assertions.assertThat((boolean)Role.SPAM.isSystemRole()).isTrue();
    }

    @Test
    void isSystemRoleShouldBeTrueWhenTemplates() {
        Assertions.assertThat((boolean)Role.TEMPLATES.isSystemRole()).isTrue();
    }

    @Test
    void isSystemRoleShouldBeTrueWhenRestoredMessages() {
        Assertions.assertThat((boolean)Role.RESTORED_MESSAGES.isSystemRole()).isTrue();
    }

    @Test
    void isSystemRoleShouldBeFalseWhenUserDefinedRole() {
        Role userRole = (Role)Role.from((String)"x-myRole").get();
        Assertions.assertThat((boolean)userRole.isSystemRole()).isFalse();
    }

    @Test
    void theINBOXMailboxNameShouldBeASystemMailbox() {
        Role role = (Role)Role.from((String)"INBOX").get();
        Assertions.assertThat((boolean)role.isSystemRole()).isTrue();
    }

    @Test
    void theInBoXMailboxNameShouldBeASystemMailbox() {
        Role role = (Role)Role.from((String)"InBoX").get();
        Assertions.assertThat((boolean)role.isSystemRole()).isTrue();
    }

    @Test
    void theDraftsMailboxNameShouldBeASystemMailbox() {
        Role role = (Role)Role.from((String)"Drafts").get();
        Assertions.assertThat((boolean)role.isSystemRole()).isTrue();
    }

    @Test
    void theDrAfTsMailboxNameShouldNotBeASystemMailbox() {
        Optional role = Role.from((String)"DrAfTs");
        Assertions.assertThat((Optional)role).isEmpty();
    }

    @Test
    void theOutboxMailboxNameShouldBeASystemMailbox() {
        Role role = (Role)Role.from((String)"Outbox").get();
        Assertions.assertThat((boolean)role.isSystemRole()).isTrue();
    }

    @Test
    void theOuTbOxMailboxNameShouldNotBeASystemMailbox() {
        Optional role = Role.from((String)"OuTbOx");
        Assertions.assertThat((Optional)role).isEmpty();
    }

    @Test
    void theSentMailboxNameShouldBeASystemMailbox() {
        Role role = (Role)Role.from((String)"Sent").get();
        Assertions.assertThat((boolean)role.isSystemRole()).isTrue();
    }

    @Test
    void theSeNtMailboxNameShouldNotBeASystemMailbox() {
        Optional role = Role.from((String)"SeNt");
        Assertions.assertThat((Optional)role).isEmpty();
    }

    @Test
    void theTrashMailboxNameShouldBeASystemMailbox() {
        Role role = (Role)Role.from((String)"Trash").get();
        Assertions.assertThat((boolean)role.isSystemRole()).isTrue();
    }

    @Test
    void theTrAsHMailboxNameShouldNotBeASystemMailbox() {
        Optional role = Role.from((String)"TrAsH");
        Assertions.assertThat((Optional)role).isEmpty();
    }

    @Test
    void theRestoredMessagesMailboxNameShouldBeASystemMailbox() {
        Role role = (Role)Role.from((String)"Restored-Messages").get();
        Assertions.assertThat((boolean)role.isSystemRole()).isTrue();
    }

    @Test
    void theReStOrEdMeSsAgEsMailboxNameShouldNotBeASystemMailbox() {
        Optional role = Role.from((String)"ReStOrEd-MeSsAgEs");
        Assertions.assertThat((Optional)role).isEmpty();
    }
}

