/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import org.apache.james.mailbox.model.MailboxACL;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MailboxACLEntryKeyTest {
    private static final String GROUP_1 = "group1";
    private static final String USER_1 = "user1";

    MailboxACLEntryKeyTest() {
    }

    @Test
    void testUser() {
        Assertions.assertThat((Object)MailboxACL.EntryKey.deserialize((String)USER_1)).isEqualTo((Object)new MailboxACL.EntryKey(USER_1, MailboxACL.NameType.user, false));
    }

    @Test
    void testNegativeUser() {
        Assertions.assertThat((Object)MailboxACL.EntryKey.deserialize((String)"-user1")).isEqualTo((Object)new MailboxACL.EntryKey(USER_1, MailboxACL.NameType.user, true));
    }

    @Test
    void testGroup() {
        Assertions.assertThat((Object)MailboxACL.EntryKey.deserialize((String)"$group1")).isEqualTo((Object)new MailboxACL.EntryKey(GROUP_1, MailboxACL.NameType.group, false));
    }

    @Test
    void testNegativeGroup() {
        Assertions.assertThat((Object)MailboxACL.EntryKey.deserialize((String)(String.valueOf('-') + "$group1"))).isEqualTo((Object)new MailboxACL.EntryKey(GROUP_1, MailboxACL.NameType.group, true));
    }

    @Test
    void testOwner() {
        Assertions.assertThat((Object)MailboxACL.EntryKey.deserialize((String)MailboxACL.SpecialName.owner.toString())).isEqualTo((Object)new MailboxACL.EntryKey(MailboxACL.SpecialName.owner.toString(), MailboxACL.NameType.special, false));
    }

    @Test
    void testNegativeOwner() {
        Assertions.assertThat((Object)MailboxACL.EntryKey.deserialize((String)("-" + MailboxACL.SpecialName.owner.toString()))).isEqualTo((Object)new MailboxACL.EntryKey(MailboxACL.SpecialName.owner.toString(), MailboxACL.NameType.special, true));
    }

    @Test
    void testAnybody() {
        Assertions.assertThat((Object)MailboxACL.EntryKey.deserialize((String)MailboxACL.SpecialName.anybody.toString())).isEqualTo((Object)new MailboxACL.EntryKey(MailboxACL.SpecialName.anybody.toString(), MailboxACL.NameType.special, false));
    }

    @Test
    void testNegativeAnybody() {
        Assertions.assertThat((Object)MailboxACL.EntryKey.deserialize((String)("-" + MailboxACL.SpecialName.anybody.toString()))).isEqualTo((Object)new MailboxACL.EntryKey(MailboxACL.SpecialName.anybody.toString(), MailboxACL.NameType.special, true));
    }

    @Test
    void testAuthenticated() {
        Assertions.assertThat((Object)MailboxACL.EntryKey.deserialize((String)MailboxACL.SpecialName.authenticated.toString())).isEqualTo((Object)new MailboxACL.EntryKey(MailboxACL.SpecialName.authenticated.toString(), MailboxACL.NameType.special, false));
    }

    @Test
    void testNegativeAuthenticated() {
        Assertions.assertThat((Object)MailboxACL.EntryKey.deserialize((String)("-" + MailboxACL.SpecialName.authenticated.toString()))).isEqualTo((Object)new MailboxACL.EntryKey(MailboxACL.SpecialName.authenticated.toString(), MailboxACL.NameType.special, true));
    }

    @Test
    void testSerializeUser() {
        Assertions.assertThat((String)new MailboxACL.EntryKey(USER_1, MailboxACL.NameType.user, false).serialize()).isEqualTo(USER_1);
    }

    @Test
    void testSerializeNegativeUser() {
        Assertions.assertThat((String)new MailboxACL.EntryKey(USER_1, MailboxACL.NameType.user, true).serialize()).isEqualTo("-user1");
    }

    @Test
    void testSerializeGroup() {
        Assertions.assertThat((String)new MailboxACL.EntryKey(GROUP_1, MailboxACL.NameType.group, false).serialize()).isEqualTo("$group1");
    }

    @Test
    void testSerializeNegativeGroup() {
        Assertions.assertThat((String)new MailboxACL.EntryKey(GROUP_1, MailboxACL.NameType.group, true).serialize()).isEqualTo(String.valueOf('-') + "$group1");
    }

    @Test
    void testSerializeOwner() {
        Assertions.assertThat((String)new MailboxACL.EntryKey(MailboxACL.SpecialName.owner.toString(), MailboxACL.NameType.special, false).serialize()).isEqualTo(MailboxACL.SpecialName.owner.toString());
    }

    @Test
    void testSerializeNegativeOwner() {
        Assertions.assertThat((String)new MailboxACL.EntryKey(MailboxACL.SpecialName.owner.toString(), MailboxACL.NameType.special, true).serialize()).isEqualTo("-" + MailboxACL.SpecialName.owner.toString());
    }

    @Test
    void testSerializeAnybody() {
        Assertions.assertThat((String)new MailboxACL.EntryKey(MailboxACL.SpecialName.anybody.toString(), MailboxACL.NameType.special, false).serialize()).isEqualTo(MailboxACL.SpecialName.anybody.toString());
    }

    @Test
    void testSerializeNegativeAnybody() {
        Assertions.assertThat((String)new MailboxACL.EntryKey(MailboxACL.SpecialName.anybody.toString(), MailboxACL.NameType.special, true).serialize()).isEqualTo("-" + MailboxACL.SpecialName.anybody.toString());
    }

    @Test
    void testSerializeAuthenticated() {
        Assertions.assertThat((String)new MailboxACL.EntryKey(MailboxACL.SpecialName.authenticated.toString(), MailboxACL.NameType.special, false).serialize()).isEqualTo(MailboxACL.SpecialName.authenticated.toString());
    }

    @Test
    void testSerializeNegativeAuthenticated() {
        Assertions.assertThat((String)new MailboxACL.EntryKey(MailboxACL.SpecialName.authenticated.toString(), MailboxACL.NameType.special, true).serialize()).isEqualTo("-" + MailboxACL.SpecialName.authenticated.toString());
    }
}

