/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.Optional;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MailboxAnnotationTest {
    private static final MailboxAnnotationKey ANNOTATION_KEY = new MailboxAnnotationKey("/private/comment");
    private static final String ANNOTATION_VALUE = "anyValue";

    MailboxAnnotationTest() {
    }

    @Test
    void sizeOfAnnotationShouldBeReturnLengthOfValue() {
        MailboxAnnotation mailboxAnnotation = MailboxAnnotation.newInstance((MailboxAnnotationKey)ANNOTATION_KEY, (String)ANNOTATION_VALUE);
        Assertions.assertThat((int)mailboxAnnotation.size()).isEqualTo(8);
    }

    @Test
    void sizeOfNilAnnotationShouldBeZero() {
        MailboxAnnotation mailboxAnnotation = MailboxAnnotation.nil((MailboxAnnotationKey)ANNOTATION_KEY);
        Assertions.assertThat((int)mailboxAnnotation.size()).isEqualTo(0);
    }

    @Test
    void newInstanceShouldThrowsExceptionWithNullKey() {
        Assertions.assertThatThrownBy(() -> MailboxAnnotation.newInstance(null, null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void newInstanceShouldThrowsExceptionWithNullValue() {
        Assertions.assertThatThrownBy(() -> MailboxAnnotation.newInstance((MailboxAnnotationKey)ANNOTATION_KEY, null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void nilInstanceShouldReturnAbsentValue() {
        MailboxAnnotation annotation = MailboxAnnotation.nil((MailboxAnnotationKey)ANNOTATION_KEY);
        Assertions.assertThat((Optional)annotation.getValue()).isEmpty();
    }

    @Test
    void isNilShouldReturnTrueForNilObject() {
        MailboxAnnotation nilAnnotation = MailboxAnnotation.nil((MailboxAnnotationKey)ANNOTATION_KEY);
        Assertions.assertThat((boolean)nilAnnotation.isNil()).isTrue();
    }

    @Test
    void isNilShouldReturnFalseForNotNilObject() {
        MailboxAnnotation nilAnnotation = MailboxAnnotation.newInstance((MailboxAnnotationKey)ANNOTATION_KEY, (String)ANNOTATION_VALUE);
        Assertions.assertThat((boolean)nilAnnotation.isNil()).isFalse();
    }

    @Test
    void newInstanceMailboxAnnotationShouldCreateNewInstance() {
        MailboxAnnotation annotation = MailboxAnnotation.newInstance((MailboxAnnotationKey)ANNOTATION_KEY, (String)ANNOTATION_VALUE);
        Assertions.assertThat((Object)annotation.getKey()).isEqualTo((Object)ANNOTATION_KEY);
        Assertions.assertThat((Optional)annotation.getValue()).contains((Object)ANNOTATION_VALUE);
    }
}

