/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.Arrays;
import java.util.List;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MessageRange;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MessageRangeTest {
    MessageRangeTest() {
    }

    @Test
    void givenSomeNumbersToRangeShouldReturnThreeRanges() {
        List ranges = MessageRange.toRanges(Arrays.asList(MessageUid.of((long)1L), MessageUid.of((long)2L), MessageUid.of((long)3L), MessageUid.of((long)5L), MessageUid.of((long)6L), MessageUid.of((long)9L)));
        Assertions.assertThat((List)ranges).containsExactly((Object[])new MessageRange[]{MessageRange.range((MessageUid)MessageUid.of((long)1L), (MessageUid)MessageUid.of((long)3L)), MessageRange.range((MessageUid)MessageUid.of((long)5L), (MessageUid)MessageUid.of((long)6L)), MessageUid.of((long)9L).toRange()});
    }

    @Test
    void givenASingleNumberToRangeShouldReturnOneRange() {
        List ranges = MessageRange.toRanges(Arrays.asList(MessageUid.of((long)1L)));
        Assertions.assertThat((List)ranges).containsExactly((Object[])new MessageRange[]{MessageUid.of((long)1L).toRange()});
    }

    @Test
    void testTwoSeqUidToRange() {
        List ranges = MessageRange.toRanges(Arrays.asList(MessageUid.of((long)1L), MessageUid.of((long)2L)));
        Assertions.assertThat((List)ranges).containsExactly((Object[])new MessageRange[]{MessageRange.range((MessageUid)MessageUid.of((long)1L), (MessageUid)MessageUid.of((long)2L))});
    }

    @Test
    void splitASingletonRangeShouldReturnASingleRange() {
        MessageRange one = MessageUid.of((long)1L).toRange();
        List ranges = one.split(2);
        Assertions.assertThat((List)ranges).containsExactly((Object[])new MessageRange[]{MessageUid.of((long)1L).toRange()});
    }

    @Test
    void splitUnboundedRangeShouldReturnTheSameRange() {
        MessageRange from = MessageRange.from((MessageUid)MessageUid.of((long)1L));
        List ranges = from.split(2);
        Assertions.assertThat((List)ranges).containsExactly((Object[])new MessageRange[]{MessageRange.from((MessageUid)MessageUid.of((long)1L))});
    }

    @Test
    void splitTenElementsRangeShouldReturn4Ranges() {
        MessageRange range = MessageRange.range((MessageUid)MessageUid.of((long)1L), (MessageUid)MessageUid.of((long)10L));
        List ranges = range.split(3);
        Assertions.assertThat((List)ranges).containsExactly((Object[])new MessageRange[]{MessageRange.range((MessageUid)MessageUid.of((long)1L), (MessageUid)MessageUid.of((long)3L)), MessageRange.range((MessageUid)MessageUid.of((long)4L), (MessageUid)MessageUid.of((long)6L)), MessageRange.range((MessageUid)MessageUid.of((long)7L), (MessageUid)MessageUid.of((long)9L)), MessageUid.of((long)10L).toRange()});
    }

    @Test
    void includeShouldBeTrueWhenAfterFrom() {
        MessageRange range = MessageRange.from((MessageUid)MessageUid.of((long)3L));
        boolean actual = range.includes(MessageUid.of((long)5L));
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void includeShouldBeFalseWhenBeforeFrom() {
        MessageRange range = MessageRange.from((MessageUid)MessageUid.of((long)3L));
        boolean actual = range.includes(MessageUid.of((long)1L));
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void includeShouldBeTrueWhenEqualsFrom() {
        MessageRange range = MessageRange.from((MessageUid)MessageUid.of((long)3L));
        boolean actual = range.includes(MessageUid.of((long)3L));
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void includeShouldBeFalseWhenDifferentOne() {
        MessageRange range = MessageUid.of((long)3L).toRange();
        boolean actual = range.includes(MessageUid.of((long)1L));
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void includeShouldBeTrueWhenEqualsOne() {
        MessageRange range = MessageUid.of((long)3L).toRange();
        boolean actual = range.includes(MessageUid.of((long)3L));
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void includeShouldBeFalseWhenBeforeRange() {
        MessageRange range = MessageRange.range((MessageUid)MessageUid.of((long)3L), (MessageUid)MessageUid.of((long)6L));
        boolean actual = range.includes(MessageUid.of((long)1L));
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void includeShouldBeTrueWhenEqualsFromRange() {
        MessageRange range = MessageRange.range((MessageUid)MessageUid.of((long)3L), (MessageUid)MessageUid.of((long)6L));
        boolean actual = range.includes(MessageUid.of((long)3L));
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void includeShouldBeTrueWhenInRange() {
        MessageRange range = MessageRange.range((MessageUid)MessageUid.of((long)3L), (MessageUid)MessageUid.of((long)6L));
        boolean actual = range.includes(MessageUid.of((long)4L));
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void includeShouldBeTrueWhenEqualsToRange() {
        MessageRange range = MessageRange.range((MessageUid)MessageUid.of((long)3L), (MessageUid)MessageUid.of((long)6L));
        boolean actual = range.includes(MessageUid.of((long)6L));
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void includeShouldBeFalseWhenAfterRange() {
        MessageRange range = MessageRange.range((MessageUid)MessageUid.of((long)3L), (MessageUid)MessageUid.of((long)6L));
        boolean actual = range.includes(MessageUid.of((long)7L));
        Assertions.assertThat((boolean)actual).isFalse();
    }
}

