/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.collect.ImmutableSet;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.TestId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MultimailboxesSearchQueryTest {
    private static final SearchQuery EMPTY_QUERY = SearchQuery.matchAll();
    private static final TestId.Factory FACTORY = new TestId.Factory();
    private static final MailboxId ID_1 = FACTORY.fromString("1");
    private static final MailboxId ID_2 = FACTORY.fromString("2");

    MultimailboxesSearchQueryTest() {
    }

    @Test
    void buildShouldThrowWhenQueryIsNull() {
        Assertions.assertThatThrownBy(() -> MultimailboxesSearchQuery.from(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldBuildWheninMailboxes() {
        ImmutableSet inMailboxes = ImmutableSet.of();
        ImmutableSet notInMailboxes = ImmutableSet.of();
        MultimailboxesSearchQuery expected = new MultimailboxesSearchQuery(EMPTY_QUERY, inMailboxes, notInMailboxes, (MultimailboxesSearchQuery.Namespace)new MultimailboxesSearchQuery.AccessibleNamespace());
        MultimailboxesSearchQuery actual = MultimailboxesSearchQuery.from((SearchQuery)EMPTY_QUERY).build();
        Assertions.assertThat((Object)actual).isEqualToComparingFieldByField((Object)expected);
    }

    @Test
    void buildShouldBuildWhenEmptyMailboxes() {
        ImmutableSet inMailboxes = ImmutableSet.of();
        ImmutableSet notInMailboxes = ImmutableSet.of();
        MultimailboxesSearchQuery expected = new MultimailboxesSearchQuery(EMPTY_QUERY, inMailboxes, notInMailboxes, (MultimailboxesSearchQuery.Namespace)new MultimailboxesSearchQuery.AccessibleNamespace());
        MultimailboxesSearchQuery actual = MultimailboxesSearchQuery.from((SearchQuery)EMPTY_QUERY).inMailboxes(new MailboxId[0]).build();
        Assertions.assertThat((Object)actual).isEqualToComparingFieldByField((Object)expected);
    }

    @Test
    void buildShouldBuildWhenEmptyNotInMailboxes() {
        ImmutableSet inMailboxes = ImmutableSet.of();
        ImmutableSet notInMailboxes = ImmutableSet.of();
        MultimailboxesSearchQuery expected = new MultimailboxesSearchQuery(EMPTY_QUERY, inMailboxes, notInMailboxes, (MultimailboxesSearchQuery.Namespace)new MultimailboxesSearchQuery.AccessibleNamespace());
        MultimailboxesSearchQuery actual = MultimailboxesSearchQuery.from((SearchQuery)EMPTY_QUERY).notInMailboxes(new MailboxId[0]).build();
        Assertions.assertThat((Object)actual).isEqualToComparingFieldByField((Object)expected);
    }

    @Test
    void buildShouldBuildWhenOneMailbox() {
        ImmutableSet inMailboxes = ImmutableSet.of((Object)ID_1);
        ImmutableSet notInMailboxes = ImmutableSet.of();
        MultimailboxesSearchQuery expected = new MultimailboxesSearchQuery(EMPTY_QUERY, inMailboxes, notInMailboxes, (MultimailboxesSearchQuery.Namespace)new MultimailboxesSearchQuery.AccessibleNamespace());
        MultimailboxesSearchQuery actual = MultimailboxesSearchQuery.from((SearchQuery)EMPTY_QUERY).inMailboxes(new MailboxId[]{ID_1}).build();
        Assertions.assertThat((Object)actual).isEqualToComparingFieldByField((Object)expected);
    }

    @Test
    void buildShouldBuildWhenOneNotInMailbox() {
        ImmutableSet inMailboxes = ImmutableSet.of();
        ImmutableSet notInMailboxes = ImmutableSet.of((Object)ID_1);
        MultimailboxesSearchQuery expected = new MultimailboxesSearchQuery(EMPTY_QUERY, inMailboxes, notInMailboxes, (MultimailboxesSearchQuery.Namespace)new MultimailboxesSearchQuery.AccessibleNamespace());
        MultimailboxesSearchQuery actual = MultimailboxesSearchQuery.from((SearchQuery)EMPTY_QUERY).notInMailboxes(new MailboxId[]{ID_1}).build();
        Assertions.assertThat((Object)actual).isEqualToComparingFieldByField((Object)expected);
    }

    @Test
    void buildShouldBuildWhenAllDefined() {
        ImmutableSet inMailboxes = ImmutableSet.of((Object)ID_1);
        ImmutableSet notInMailboxes = ImmutableSet.of((Object)ID_2);
        MultimailboxesSearchQuery expected = new MultimailboxesSearchQuery(EMPTY_QUERY, inMailboxes, notInMailboxes, (MultimailboxesSearchQuery.Namespace)new MultimailboxesSearchQuery.AccessibleNamespace());
        MultimailboxesSearchQuery actual = MultimailboxesSearchQuery.from((SearchQuery)EMPTY_QUERY).inMailboxes(new MailboxId[]{ID_1}).notInMailboxes(new MailboxId[]{ID_2}).build();
        Assertions.assertThat((Object)actual).isEqualToComparingFieldByField((Object)expected);
    }
}

