/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.model.QuotaOperation;
import org.apache.james.mailbox.model.QuotaRoot;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class QuotaOperationTest {
    static final QuotaRoot QUOTA_ROOT = QuotaRoot.quotaRoot((String)"user", Optional.empty());

    QuotaOperationTest() {
    }

    @Test
    void shouldRespectBeanContract() {
        EqualsVerifier.forClass(QuotaOperation.class).verify();
    }

    @Test
    void shouldNotThrowWhenCountIsZero() {
        Assertions.assertThatCode(() -> new QuotaOperation(QUOTA_ROOT, QuotaCountUsage.count((long)0L), QuotaSizeUsage.size((long)5L))).doesNotThrowAnyException();
    }

    @Test
    void shouldThrowWhenCountIsNegative() {
        Assertions.assertThatThrownBy(() -> new QuotaOperation(QUOTA_ROOT, QuotaCountUsage.count((long)-1L), QuotaSizeUsage.size((long)5L))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldNotThrowWhenSizeIsZero() {
        Assertions.assertThatCode(() -> new QuotaOperation(QUOTA_ROOT, QuotaCountUsage.count((long)5L), QuotaSizeUsage.size((long)0L))).doesNotThrowAnyException();
    }

    @Test
    void shouldThrowWhenSizeIsNegative() {
        Assertions.assertThatThrownBy(() -> new QuotaOperation(QUOTA_ROOT, QuotaCountUsage.count((long)5L), QuotaSizeUsage.size((long)-1L))).isInstanceOf(IllegalArgumentException.class);
    }
}

