/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRatio;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class QuotaRatioTest {
    private static final Quota<QuotaSizeLimit, QuotaSizeUsage> QUOTA_SIZE = Quota.builder().used((QuotaUsageValue)QuotaSizeUsage.size((long)15L)).computedLimit((QuotaLimitValue)QuotaSizeLimit.size((long)60L)).build();
    private static final Quota<QuotaCountLimit, QuotaCountUsage> QUOTA_COUNT = Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)1L)).computedLimit((QuotaLimitValue)QuotaCountLimit.count((long)2L)).build();

    QuotaRatioTest() {
    }

    @Test
    void shouldMatchBeanContact() {
        EqualsVerifier.forClass(QuotaRatio.class).verify();
    }

    @Test
    void quotaRatioShouldThrowWhenQuotaSizeIsNull() {
        Assertions.assertThatThrownBy(() -> QuotaRatio.from(null, QUOTA_COUNT)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void quotaRatioShouldThrowWhenQuotaCountIsNull() {
        Assertions.assertThatThrownBy(() -> QuotaRatio.from(QUOTA_SIZE, null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void quotaSizeShouldReturnTheQuotaSize() {
        QuotaRatio quotaRatio = QuotaRatio.from(QUOTA_SIZE, QUOTA_COUNT);
        Assertions.assertThat((Object)quotaRatio.getQuotaSize()).isEqualTo(QUOTA_SIZE);
    }

    @Test
    void quotaCountShouldReturnTheQuotaCount() {
        QuotaRatio quotaRatio = QuotaRatio.from(QUOTA_SIZE, QUOTA_COUNT);
        Assertions.assertThat((Object)quotaRatio.getQuotaCount()).isEqualTo(QUOTA_COUNT);
    }

    @Test
    void maxShouldReturnTheMaxRatio() {
        double max = QuotaRatio.from(QUOTA_SIZE, QUOTA_COUNT).max();
        Assertions.assertThat((double)max).isEqualTo(0.5);
    }
}

