/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.stream.IntStream;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.model.UidValidity;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

class UidValidityTest {
    UidValidityTest() {
    }

    @Test
    void shouldRespectBeanContract() {
        EqualsVerifier.forClass(UidValidity.class).verify();
    }

    @Test
    void ofShouldReturnValidUidValidity() {
        long expectedValue = 123456789L;
        UidValidity uidValidity = UidValidity.of((long)expectedValue);
        Assertions.assertThat((long)uidValidity.asLong()).isEqualTo(expectedValue);
    }

    @Test
    void ofShouldThrowWhenZero() {
        Assertions.assertThatThrownBy(() -> UidValidity.of((long)0L)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void ofShouldThrowWhenNegative() {
        Assertions.assertThatThrownBy(() -> UidValidity.of((long)-1L)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void ofShouldThrowWhenTooBig() {
        Assertions.assertThatThrownBy(() -> UidValidity.of((long)0x100000000L)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromSupplierShouldNotThrowWhenZeroIsGenerated() {
        Assertions.assertThatCode(() -> UidValidity.fromSupplier(() -> 0L)).doesNotThrowAnyException();
    }

    @Test
    void fromSupplierShouldNotThrowWhenNegativeIsGenerated() {
        Assertions.assertThatCode(() -> UidValidity.fromSupplier(() -> -42L)).doesNotThrowAnyException();
    }

    @Test
    void fromSupplierShouldNotThrowWhenUpperBoundExclusiveIsGenerated() {
        Assertions.assertThatCode(() -> UidValidity.fromSupplier(() -> 0x100000000L)).doesNotThrowAnyException();
    }

    @Test
    void fromSupplierShouldNotThrowWhenUpperBoundInclusiveIsGenerated() {
        Assertions.assertThatCode(() -> UidValidity.fromSupplier(() -> 0xFFFFFFFFL)).doesNotThrowAnyException();
    }

    @Test
    void fromSupplierShouldNotThrowWhenHigherThanUpperBoundIsGenerated() {
        Assertions.assertThatCode(() -> UidValidity.fromSupplier(() -> 0x100000001L)).doesNotThrowAnyException();
    }

    @Test
    void fromSupplierShouldNotThrowWhenLowerThanUpperBoundIsGenerated() {
        Assertions.assertThatCode(() -> UidValidity.fromSupplier(() -> 0xFFFFFFFEL)).doesNotThrowAnyException();
    }

    @RepeatedTest(value=10000)
    void randomShouldGenerateValidValues() {
        Assertions.assertThatCode(UidValidity::generate).doesNotThrowAnyException();
    }

    @Disabled(value="On average upon generating 1.000.000 UidValidity we notice 125 duplicates")
    @Test
    void randomShouldNotLeadToCollision() {
        int count = 1000000;
        long distinctCount = IntStream.range(0, count).mapToObj(any -> UidValidity.generate()).distinct().count();
        Assertions.assertThat((long)distinctCount).isEqualTo((long)count);
    }
}

