/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model.search;

import com.google.re2j.Pattern;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.model.search.PrefixedRegex;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PrefixedRegexTest {
    private static final char PATH_DELIMITER = '.';
    private static final String PREFIX = "name";
    private static final String EMPTY_PREFIX = "";

    PrefixedRegexTest() {
    }

    @Test
    public void shouldMatchBeanContract() {
        EqualsVerifier.forClass(PrefixedRegex.class).withIgnoredFields(new String[]{"pattern"}).withPrefabValues(Pattern.class, (Object)Pattern.compile((String)"a"), (Object)Pattern.compile((String)"b")).verify();
    }

    @Test
    void slowRegexShouldNotBeConstructedByFuzzing() throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            executorService.submit(() -> {
                PrefixedRegex prefixedRegex = new PrefixedRegex(EMPTY_PREFIX, "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a", '.');
                prefixedRegex.isExpressionMatch("aa%%%%%%%%%%%%%%%%");
            }).get(30L, TimeUnit.SECONDS);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    @Test
    void isWildShouldReturnTrueWhenOnlyFreeWildcard() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, "*", '.');
        boolean actual = prefixedRegex.isWild();
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isWildShouldReturnTrueWhenOnlyLocalWildcard() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, "%", '.');
        boolean actual = prefixedRegex.isWild();
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isWildShouldReturnTrueWhenFreeWildcardAtBeginning() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, "*One", '.');
        boolean actual = prefixedRegex.isWild();
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isWildShouldReturnTrueWhenLocalWildcardAtBeginning() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, "%One", '.');
        boolean actual = prefixedRegex.isWild();
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isWildShouldReturnTrueWhenFreeWildcardInMiddle() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, "A*A", '.');
        boolean actual = prefixedRegex.isWild();
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isWildShouldReturnTrueWhenLocalWildcardInMiddle() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, "A%A", '.');
        boolean actual = prefixedRegex.isWild();
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isWildShouldReturnTrueWhenFreeWildcardAtEnd() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, "One*", '.');
        boolean actual = prefixedRegex.isWild();
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isWildShouldReturnTrueWhenLocalWildcardAtEnd() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, "One%", '.');
        boolean actual = prefixedRegex.isWild();
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isWildShouldReturnFalseWhenEmptyExpression() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, EMPTY_PREFIX, '.');
        boolean actual = prefixedRegex.isWild();
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isWildShouldReturnFalseWhenNullExpression() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, null, '.');
        boolean actual = prefixedRegex.isWild();
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isWildShouldReturnFalseWhenNoWildcard() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, "ONE", '.');
        boolean actual = prefixedRegex.isWild();
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void getCombinedNameShouldWork() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, "mailbox", '.');
        String actual = prefixedRegex.getCombinedName();
        Assertions.assertThat((String)actual).isEqualTo("name.mailbox");
    }

    @Test
    void getCombinedNameShouldWorkWhenEmptyExpression() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, EMPTY_PREFIX, '.');
        String actual = prefixedRegex.getCombinedName();
        Assertions.assertThat((String)actual).isEqualTo(PREFIX);
    }

    @Test
    void getCombinedNameShouldReturnEmptyStringWhenNullMailboxPathAndExpression() {
        String prefix = null;
        String regex = null;
        PrefixedRegex prefixedRegex = new PrefixedRegex(prefix, regex, '.');
        String actual = prefixedRegex.getCombinedName();
        Assertions.assertThat((String)actual).isEmpty();
    }

    @Test
    void getCombinedNameShouldIgnoreDelimiterWhenPresentAtBeginningOfExpression() {
        PrefixedRegex prefixedRegex = new PrefixedRegex(PREFIX, ".mailbox", '.');
        String actual = prefixedRegex.getCombinedName();
        Assertions.assertThat((String)actual).isEqualTo("name.mailbox");
    }

    @Test
    void getCombinedNameShouldIgnoreDelimiterWhenPresentAtEndOfMailboxName() {
        PrefixedRegex prefixedRegex = new PrefixedRegex("name.", ".mailbox", '.');
        String actual = prefixedRegex.getCombinedName();
        Assertions.assertThat((String)actual).isEqualTo("name.mailbox");
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenNullExpression() {
        PrefixedRegex testee = new PrefixedRegex(PREFIX, null, '.');
        boolean actual = testee.isExpressionMatch("folder");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenMatching() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox", '.');
        boolean actual = testee.isExpressionMatch("mailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenNameBeginsWithDelimiter() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox", '.');
        boolean actual = testee.isExpressionMatch(".mailbox");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenNameEndsWithDelimiter() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox", '.');
        boolean actual = testee.isExpressionMatch("mailbox.");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchFolderWhenNoMatching() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchFolderWithExpandedEndName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox", '.');
        boolean actual = testee.isExpressionMatch("mailbox123");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchSubFolder() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox", '.');
        boolean actual = testee.isExpressionMatch("mailbox.123");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldReturnTrueWhenEmptyNameAndExpression() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, EMPTY_PREFIX, '.');
        boolean actual = testee.isExpressionMatch(EMPTY_PREFIX);
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenEmptyExpressionAndNameBeginsWithDelimiter() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, EMPTY_PREFIX, '.');
        boolean actual = testee.isExpressionMatch(".123");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchFolderWhenEmptyExpression() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, EMPTY_PREFIX, '.');
        boolean actual = testee.isExpressionMatch("folder");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldReturnTrueWhenEmptyNameAndOnlyLocalWildcard() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "%", '.');
        boolean actual = testee.isExpressionMatch(EMPTY_PREFIX);
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnTrueWhenOnlyLocalWildcard() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "%", '.');
        boolean actual = testee.isExpressionMatch("folder");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldNotMatchSubFolderWhenOnlyLocalWildcard() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "%", '.');
        boolean actual = testee.isExpressionMatch("mailbox.sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldReturnTrueWhenEmptyNameAndOnlyFreeWildcard() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "*", '.');
        boolean actual = testee.isExpressionMatch(EMPTY_PREFIX);
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenOnlyFreeWildcard() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "*", '.');
        boolean actual = testee.isExpressionMatch("sub");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchSubFolderWhenOnlyFreeWildcard() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "*", '.');
        boolean actual = testee.isExpressionMatch("mailbox.sub");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenEmptyNameAndLocalWildcardAtEnd() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox%", '.');
        boolean actual = testee.isExpressionMatch(EMPTY_PREFIX);
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenLocalWildcardAtEndAndNoMatching() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox%", '.');
        boolean actual = testee.isExpressionMatch("sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenLocalWildcardAtEndNotUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox%", '.');
        boolean actual = testee.isExpressionMatch("mailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnTrueWhenLocalWildcardAtEndUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox%", '.');
        boolean actual = testee.isExpressionMatch("mailboxsub");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldNotMatchSubFolderWhenLocalWildcardAtEnd() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox%", '.');
        boolean actual = testee.isExpressionMatch("mailbox.sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenEmptyNameAndLocalWildcardAtBeginning() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "%mailbox", '.');
        boolean actual = testee.isExpressionMatch(EMPTY_PREFIX);
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchFolderWhenLocalWildcardAtBeginningAndNoMatching() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "%mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenLocalWildcardAtBeginningNotUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "%mailbox", '.');
        boolean actual = testee.isExpressionMatch("mailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenLocalWildcardAtBeginningUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "%mailbox", '.');
        boolean actual = testee.isExpressionMatch("submailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldNotMatchSubFolderWhenLocalWildcardAtBeginning() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "%mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub.mailbox");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchDeeplyNestedFolderWhenLocalWildcardAtBeginning() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "%mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub.mailbox.sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenEmptyNameAndLocalWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%mailbox", '.');
        boolean actual = testee.isExpressionMatch(EMPTY_PREFIX);
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenLocalWildcardInMiddleAndMissingEndName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenLocalWildcardInMiddleAndMatching() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%mailbox", '.');
        boolean actual = testee.isExpressionMatch("submailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenLocalWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub123mailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldNotMatchSubFolderWhenLocalWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub.mailbox");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchSubFolderWhenLocalWildcardInMiddleAndExpandedMiddleName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub.123mailbox");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenLocalWildcardInMiddleAndMissingBeginningName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%mailbox", '.');
        boolean actual = testee.isExpressionMatch("mailbox");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchDeeplyNestedFolderWhenLocalWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%mailbox", '.');
        boolean actual = testee.isExpressionMatch("subw.hat.eve.rmailbox");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchSubFolderWhenFreeWildcardAtEnd() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox*", '.');
        boolean actual = testee.isExpressionMatch("mailbox.sub");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenEmptyNameAndFreeWildcardAtEnd() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox*", '.');
        boolean actual = testee.isExpressionMatch(EMPTY_PREFIX);
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchFolderWhenFreeWildcardAtEndAndNoMatching() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox*", '.');
        boolean actual = testee.isExpressionMatch("sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenFreeWildcardAtEndNotUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox*", '.');
        boolean actual = testee.isExpressionMatch("mailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenFreeWildcardAtEndUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "mailbox*", '.');
        boolean actual = testee.isExpressionMatch("mailbox123");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenEmptyNameAndFreeWildcardAtBeginning() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "*mailbox", '.');
        boolean actual = testee.isExpressionMatch(EMPTY_PREFIX);
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchFolderWhenFreeWildcardAtBeginningAndNoMatching() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "*mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenFreeWildcardAtBeginningNotUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "*mailbox", '.');
        boolean actual = testee.isExpressionMatch("mailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenFreeWildcardAtBeginningUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "*mailbox", '.');
        boolean actual = testee.isExpressionMatch("submailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchSubFolderWhenFreeWildcardAtBeginning() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "*mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub.mailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenEmptyNameAndFreeWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox", '.');
        boolean actual = testee.isExpressionMatch(EMPTY_PREFIX);
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchFolderWhenFreeWildcardInMiddleAndMissingEndName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenFreeWildcardInMiddleNotUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox", '.');
        boolean actual = testee.isExpressionMatch("submailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchSubFolderWhenFreeWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub.mailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenFreeWildcardInMiddleNotUsedAndMissingBeginningName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox", '.');
        boolean actual = testee.isExpressionMatch("mailbox");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchDeeplyNestedFolderWhenFreeWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox", '.');
        boolean actual = testee.isExpressionMatch("subw.hat.eve.rmailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenEmptyNameAndDoubleFreeWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub**mailbox", '.');
        boolean actual = testee.isExpressionMatch(EMPTY_PREFIX);
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenDoubleFreeWildcardInMiddleAndMissingEndName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub**mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldReturnTrueWhenDoubleFreeWildcardInMiddleNotUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub**mailbox", '.');
        boolean actual = testee.isExpressionMatch("submailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchSubFolderWhenDoubleFreeWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub**mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub.mailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenDoubleFreeWildcardInMiddleAndMissingBeginningName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub**mailbox", '.');
        boolean actual = testee.isExpressionMatch("mailbox");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchDeeplyNestedFolderWhenDoubleFreeWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub**mailbox", '.');
        boolean actual = testee.isExpressionMatch("subw.hat.eve.rmailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenEmptyNameAndFreeLocalWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*%mailbox", '.');
        boolean actual = testee.isExpressionMatch(EMPTY_PREFIX);
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenFreeLocalWildcardInMiddleAndMissingEndName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*%mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenFreeLocalWildcardInMiddleNotUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*%mailbox", '.');
        boolean actual = testee.isExpressionMatch("submailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchSubFolderWhenFreeLocalWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*%mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub.mailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenFreeLocalWildcardInMiddleAndMissingBeginningName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*%mailbox", '.');
        boolean actual = testee.isExpressionMatch("mailbox");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchDeeplyNestedFolderWhenFreeLocalWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*%mailbox", '.');
        boolean actual = testee.isExpressionMatch("subw.hat.eve.rmailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldReturnFalseWhenEmptyNameAndLocalFreeWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%*mailbox", '.');
        boolean actual = testee.isExpressionMatch(EMPTY_PREFIX);
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchFolderWhenLocalFreeWildcardInMiddleAndMissingEndName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%*mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenLocalFreewildcardInMiddleNotUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%*mailbox", '.');
        boolean actual = testee.isExpressionMatch("submailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchSubFolderWhenLocalFreeWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%*mailbox", '.');
        boolean actual = testee.isExpressionMatch("sub.mailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldNotMatchFolderWhenLocalFreeWildcardInMiddleAndMissingBeginningName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%*mailbox", '.');
        boolean actual = testee.isExpressionMatch("mailbox");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchDeeplyNestedFolderWhenLocalFreeWildcardInMiddle() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%*mailbox", '.');
        boolean actual = testee.isExpressionMatch("subw.hat.eve.rmailbox");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenMultipleFreeWildcards() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox*sub**", '.');
        boolean actual = testee.isExpressionMatch("submailboxsub");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchDeeplyNestedFolderWhenMultipleFreeWildcardsNotUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox*sub**", '.');
        boolean actual = testee.isExpressionMatch("sub.mailbox.sub");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchDeeplyNestedFolderWhenMultipleFreeWildcardsUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox*sub**", '.');
        boolean actual = testee.isExpressionMatch("subtosh.boshmailboxtosh.boshsubboshtosh");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldNotMatchDeeplyNestedFolderWhenMultipleFreeWildcardsAndMissingMiddleName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox*sub**", '.');
        boolean actual = testee.isExpressionMatch("sub.a.sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchDeeplyNestedFolderWhenMultipleFreeWildcardsAndMissingEndName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox*sub**", '.');
        boolean actual = testee.isExpressionMatch("sub.a.submailbox.u");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchDeeplyNestedFolderWhenMultipleFreeWildcardsAndMissingBeginningdName() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox*sub**", '.');
        boolean actual = testee.isExpressionMatch("utosh.boshmailboxtosh.boshsubasubboshtoshmailboxu");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenMixedLocalFreeWildcardsNotUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%mailbox*sub", '.');
        boolean actual = testee.isExpressionMatch("submailboxsub");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldNotMatchSubFolderWhenMixedLocalFreeWildcards() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub%mailbox*sub", '.');
        boolean actual = testee.isExpressionMatch("sub.mailboxsub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenMixedFreeLocalWildcardsNotUsed() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox%sub", '.');
        boolean actual = testee.isExpressionMatch("submailboxsub");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchSubFolderWhenMixedFreeLocalWildcards() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox%sub", '.');
        boolean actual = testee.isExpressionMatch("sub.mailboxsub");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldNotMatchSubFolderWhenMixedFreeLocalWildcards() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox%sub", '.');
        boolean actual = testee.isExpressionMatch("submailbox.sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchFolderWhenMixedFreeLocalWildcards() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox%sub", '.');
        boolean actual = testee.isExpressionMatch("submailboxwhateversub");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldNotMatchSubFolderEndingWithDelimiterWhenMixedFreeLocalWildcards() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox%sub", '.');
        boolean actual = testee.isExpressionMatch("submailboxsub.Whatever.");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchDeeplyNestedFolderWhenMixedFreeLocalWildcards() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox%sub", '.');
        boolean actual = testee.isExpressionMatch("sub.mailboxsub.sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchSubFoldeWhenMixedFreeLocalWildcards() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox%sub", '.');
        boolean actual = testee.isExpressionMatch("sub.mailboxsub");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchDeeplyNestedFoldeWhenMixedFreeLocalWildcards() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "sub*mailbox%sub", '.');
        boolean actual = testee.isExpressionMatch("sub.whatever.mailbox123sub");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldNotMatchFolderWhenTwoLocalPathDelimitedWildcards() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "%.%", '.');
        boolean actual = testee.isExpressionMatch("mailbox");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchDeeplyNestedFolderWhenTwoLocalPathDelimitedWildcards() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "%.%", '.');
        boolean actual = testee.isExpressionMatch("mailbox.sub.sub");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldMatchSubFolderWhenTwoLocalPathDelimitedWildcards() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "%.%", '.');
        boolean actual = testee.isExpressionMatch("mailbox.sub");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchSubFolderWhenFreeWildcardAndPathDelimiterAtBeginning() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "*.test", '.');
        boolean actual = testee.isExpressionMatch("blah.test");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldNotMatchSubFolderWhenWhenFreeWildcardAndPathDelimiterAtBeginning() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "*.test", '.');
        boolean actual = testee.isExpressionMatch("blah.test3");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldNotMatchDeeplyNestedFolderWhenFreeWildcardAndPathDelimiterAtBeginning() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "*.test", '.');
        boolean actual = testee.isExpressionMatch("blah.test.go");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldIgnoreRegexInjection() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "folder^$!)(%3", '.');
        boolean actual = testee.isExpressionMatch("folder^$!)(123");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldIgnoreRegexInjectionWhenUsingEndOfQuoteAndNoMatching() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "\\Efo.", '.');
        boolean actual = testee.isExpressionMatch("\\Efol");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldIgnoreRegexInjectionWhenUsingEndOfQuoteAndMatching() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "\\Efo.", '.');
        boolean actual = testee.isExpressionMatch("\\Efo.");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldIgnoreRegexInjectionWhenUsingBeginOfQuoteAndNoMatching() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "\\Qfo?", '.');
        boolean actual = testee.isExpressionMatch("\\Qfol");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isExpressionMatchShouldIgnoreRegexInjectionWhenUsingBeginOfQuoteAndMatching() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "\\Qfo?", '.');
        boolean actual = testee.isExpressionMatch("\\Qfo?");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldNotEscapeFreeWildcard() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "folder\\*", '.');
        boolean actual = testee.isExpressionMatch("folder\\123");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void isExpressionMatchShouldNotEscapeLocalWildcard() {
        PrefixedRegex testee = new PrefixedRegex(EMPTY_PREFIX, "folder\\%", '.');
        boolean actual = testee.isExpressionMatch("folder\\123");
        Assertions.assertThat((boolean)actual).isTrue();
    }
}

