/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model.search;

import org.apache.james.mailbox.model.search.Wildcard;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WildcardTest {
    WildcardTest() {
    }

    @Test
    void isWildShouldBeTrue() {
        Assertions.assertThat((boolean)Wildcard.INSTANCE.isWild()).isTrue();
    }

    @Test
    void getCombinedNameShouldReturnWildcard() {
        Assertions.assertThat((String)Wildcard.INSTANCE.getCombinedName()).isEqualTo(String.valueOf('*'));
    }

    @Test
    void isExpressionMatchShouldMatchAnyValue() {
        Assertions.assertThat((boolean)Wildcard.INSTANCE.isExpressionMatch("any")).isTrue();
    }

    @Test
    void isExpressionMatchShouldMatchEmptyValue() {
        Assertions.assertThat((boolean)Wildcard.INSTANCE.isExpressionMatch("")).isTrue();
    }

    @Test
    void isExpressionMatchShouldThrowOnNullValue() {
        Assertions.assertThatThrownBy(() -> Wildcard.INSTANCE.isExpressionMatch(null)).isInstanceOf(NullPointerException.class);
    }
}

