/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import java.util.Set;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.FlagsExtractor;
import org.apache.james.mailbox.cassandra.table.CassandraApplicableFlagTable;
import reactor.core.publisher.Mono;

public class CassandraApplicableFlagDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement select;
    private final PreparedStatement delete;

    @Inject
    public CassandraApplicableFlagDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.select = this.prepareSelect(session);
        this.delete = this.prepareDelete(session);
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraApplicableFlagTable.FIELDS).from("applicableFlag").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("applicableFlag").where(QueryBuilder.eq((String)"mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId"))));
    }

    public Mono<Void> delete(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind().setUUID("mailboxId", mailboxId.asUuid()));
    }

    public Mono<Flags> retrieveApplicableFlag(CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.select.bind().setUUID("mailboxId", mailboxId.asUuid())).map(FlagsExtractor::getApplicableFlags);
    }

    public Mono<Void> updateApplicableFlags(CassandraId cassandraId, Set<String> toBeAdded) {
        if (toBeAdded.isEmpty()) {
            return Mono.empty();
        }
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.updateQuery(cassandraId, toBeAdded));
    }

    private Update.Where updateQuery(CassandraId cassandraId, Set<String> userFlags) {
        return this.addUserFlagsToQuery(userFlags, QueryBuilder.update((String)"applicableFlag").with()).where(QueryBuilder.eq((String)"mailboxId", (Object)cassandraId.asUuid()));
    }

    private Update.Assignments addUserFlagsToQuery(Set<String> userFlags, Update.Assignments updateQuery) {
        userFlags.forEach(userFlag -> updateQuery.and(QueryBuilder.add((String)"userFlags", (Object)userFlag)));
        return updateQuery;
    }
}

