/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.CassandraTypesProvider;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.backends.cassandra.utils.CassandraUtils;
import org.apache.james.core.Username;
import org.apache.james.mailbox.cassandra.GhostMailbox;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraIdAndPath;
import org.apache.james.mailbox.cassandra.mail.utils.MailboxBaseTupleUtil;
import org.apache.james.mailbox.cassandra.table.CassandraMailboxPathTable;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.util.FunctionalUtils;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailboxPathDAOImpl {
    private static final int FIRST_CELL = 0;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final MailboxBaseTupleUtil mailboxBaseTupleUtil;
    private final CassandraUtils cassandraUtils;
    private final PreparedStatement delete;
    private final PreparedStatement insert;
    private final PreparedStatement select;
    private final PreparedStatement selectAllForUser;
    private final PreparedStatement selectAll;
    private final PreparedStatement countAll;
    private final ConsistencyLevel consistencyLevel;

    @Inject
    public CassandraMailboxPathDAOImpl(Session session, CassandraTypesProvider typesProvider, CassandraUtils cassandraUtils, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.mailboxBaseTupleUtil = new MailboxBaseTupleUtil(typesProvider);
        this.cassandraUtils = cassandraUtils;
        this.consistencyLevel = consistenciesConfiguration.getRegular();
        this.insert = this.prepareInsert(session);
        this.delete = this.prepareDelete(session);
        this.select = this.prepareSelect(session);
        this.selectAllForUser = this.prepareSelectAllForUser(session);
        this.selectAll = this.prepareSelectAll(session);
        this.countAll = this.prepareCountAll(session);
    }

    @VisibleForTesting
    public CassandraMailboxPathDAOImpl(Session session, CassandraTypesProvider typesProvider, CassandraConsistenciesConfiguration consistenciesConfiguration) {
        this(session, typesProvider, CassandraUtils.WITH_DEFAULT_CONFIGURATION, consistenciesConfiguration);
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("mailboxPath").where(QueryBuilder.eq((String)"namespaceAndUser", (Object)QueryBuilder.bindMarker((String)"namespaceAndUser"))).and(QueryBuilder.eq((String)"mailboxName", (Object)QueryBuilder.bindMarker((String)"mailboxName"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"mailboxPath").value("namespaceAndUser", (Object)QueryBuilder.bindMarker((String)"namespaceAndUser")).value("mailboxName", (Object)QueryBuilder.bindMarker((String)"mailboxName")).value("mailboxId", (Object)QueryBuilder.bindMarker((String)"mailboxId")));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMailboxPathTable.FIELDS).from("mailboxPath").where(QueryBuilder.eq((String)"namespaceAndUser", (Object)QueryBuilder.bindMarker((String)"namespaceAndUser"))).and(QueryBuilder.eq((String)"mailboxName", (Object)QueryBuilder.bindMarker((String)"mailboxName"))));
    }

    private PreparedStatement prepareSelectAllForUser(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMailboxPathTable.FIELDS).from("mailboxPath").where(QueryBuilder.eq((String)"namespaceAndUser", (Object)QueryBuilder.bindMarker((String)"namespaceAndUser"))));
    }

    private PreparedStatement prepareSelectAll(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])CassandraMailboxPathTable.FIELDS).from("mailboxPath"));
    }

    private PreparedStatement prepareCountAll(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((Object[])new Object[]{QueryBuilder.count((Object)"namespaceAndUser")}).from("mailboxPath"));
    }

    public Mono<CassandraIdAndPath> retrieveId(MailboxPath mailboxPath) {
        return this.cassandraAsyncExecutor.executeSingleRow(this.select.bind().setUDTValue("namespaceAndUser", this.mailboxBaseTupleUtil.createMailboxBaseUDT(mailboxPath.getNamespace(), mailboxPath.getUser())).setString("mailboxName", mailboxPath.getName()).setConsistencyLevel(this.consistencyLevel)).map(this::fromRowToCassandraIdAndPath).map((Function)FunctionalUtils.toFunction(this::logGhostMailboxSuccess)).switchIfEmpty(ReactorUtils.executeAndEmpty(() -> this.logGhostMailboxFailure(mailboxPath)));
    }

    public Flux<CassandraIdAndPath> listUserMailboxes(String namespace, Username user) {
        return this.cassandraAsyncExecutor.execute((Statement)this.selectAllForUser.bind().setUDTValue("namespaceAndUser", this.mailboxBaseTupleUtil.createMailboxBaseUDT(namespace, user))).flatMapMany(arg_0 -> ((CassandraUtils)this.cassandraUtils).convertToFlux(arg_0)).map(this::fromRowToCassandraIdAndPath).map((Function)FunctionalUtils.toFunction(this::logReadSuccess));
    }

    public void logGhostMailboxSuccess(CassandraIdAndPath value) {
        this.logReadSuccess(value);
    }

    public void logGhostMailboxFailure(MailboxPath mailboxPath) {
        GhostMailbox.logger().addField(GhostMailbox.MAILBOX_NAME, (Object)mailboxPath).addField(GhostMailbox.TYPE, (Object)"readMiss").log(logger -> logger.debug("Read mailbox missed"));
    }

    private void logReadSuccess(CassandraIdAndPath cassandraIdAndPath) {
        GhostMailbox.logger().addField(GhostMailbox.MAILBOX_NAME, (Object)cassandraIdAndPath.getMailboxPath()).addField(GhostMailbox.TYPE, (Object)"readSuccess").addField(GhostMailbox.MAILBOX_ID, (Object)cassandraIdAndPath.getCassandraId()).log(logger -> logger.debug("Read mailbox succeeded"));
    }

    private CassandraIdAndPath fromRowToCassandraIdAndPath(Row row) {
        return new CassandraIdAndPath(CassandraId.of(row.getUUID("mailboxId")), new MailboxPath(row.getUDTValue("namespaceAndUser").getString("namespace"), Username.of((String)row.getUDTValue("namespaceAndUser").getString("user")), row.getString("mailboxName")));
    }

    @VisibleForTesting
    public Mono<Boolean> save(MailboxPath mailboxPath, CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)this.insert.bind().setUDTValue("namespaceAndUser", this.mailboxBaseTupleUtil.createMailboxBaseUDT(mailboxPath.getNamespace(), mailboxPath.getUser())).setString("mailboxName", mailboxPath.getName()).setUUID("mailboxId", mailboxId.asUuid()));
    }

    public Mono<Void> delete(MailboxPath mailboxPath) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.delete.bind().setUDTValue("namespaceAndUser", this.mailboxBaseTupleUtil.createMailboxBaseUDT(mailboxPath.getNamespace(), mailboxPath.getUser())).setString("mailboxName", mailboxPath.getName()));
    }

    public Flux<CassandraIdAndPath> readAll() {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.selectAll.bind()).map(this::fromRowToCassandraIdAndPath);
    }

    public Mono<Long> countAll() {
        return this.cassandraAsyncExecutor.executeSingleRowOptional((Statement)this.countAll.bind()).map(optional -> optional.map(row -> row.getLong(0)).orElse(0L));
    }
}

