/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.migration;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.mailbox.cassandra.mail.CassandraIdAndPath;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxPathV2DAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxPathV3DAO;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public class MailboxPathV3Migration
implements Migration {
    public static final Logger LOGGER = LoggerFactory.getLogger(MailboxPathV3Migration.class);
    public static final TaskType TYPE = TaskType.of((String)"cassandra-mailbox-path-v3-migration");
    private static final int CONCURRENCY = 50;
    private static final int MAX_ATTEMPTS = 3;
    private static final Duration MIN_BACKOFF = Duration.ofSeconds(1L);
    private final CassandraMailboxPathV2DAO daoV2;
    private final CassandraMailboxPathV3DAO daoV3;
    private final CassandraMailboxDAO mailboxDAO;
    private final long initialCount;

    @Inject
    public MailboxPathV3Migration(CassandraMailboxPathV2DAO daoV2, CassandraMailboxPathV3DAO daoV3, CassandraMailboxDAO mailboxDAO) {
        this.daoV2 = daoV2;
        this.daoV3 = daoV3;
        this.mailboxDAO = mailboxDAO;
        this.initialCount = this.getCurrentCount();
    }

    public void apply() {
        this.daoV2.listAll().flatMap(this::migrate, 50).doOnError(t -> LOGGER.error("Error while performing migration", t)).blockLast();
    }

    private Mono<Void> migrate(CassandraIdAndPath idAndPath) {
        return this.mailboxDAO.retrieveMailbox(idAndPath.getCassandraId()).flatMap(mailbox -> this.daoV3.save((Mailbox)mailbox).then(this.daoV2.delete(idAndPath.getMailboxPath()))).onErrorResume(error -> this.handleErrorMigrate(idAndPath, (Throwable)error)).retryWhen((Retry)RetryBackoffSpec.backoff((long)3L, (Duration)MIN_BACKOFF).jitter(0.5).scheduler(Schedulers.elastic())).then();
    }

    private Mono<Void> handleErrorMigrate(CassandraIdAndPath idAndPath, Throwable throwable) {
        LOGGER.error("Error while performing migration for path {}", (Object)idAndPath.getMailboxPath(), (Object)throwable);
        return Mono.error((Throwable)throwable);
    }

    public Task asTask() {
        return new MailboxPathV3MigrationTask(this);
    }

    AdditionalInformation getAdditionalInformation() {
        return new AdditionalInformation(this.getCurrentCount(), this.initialCount, Clock.systemUTC().instant());
    }

    private Long getCurrentCount() {
        return (Long)this.daoV2.listAll().count().block();
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final long remainingCount;
        private final long initialCount;
        private final Instant timestamp;

        public AdditionalInformation(long remainingCount, long initialCount, Instant timestamp) {
            this.remainingCount = remainingCount;
            this.initialCount = initialCount;
            this.timestamp = timestamp;
        }

        public long getRemainingCount() {
            return this.remainingCount;
        }

        public long getInitialCount() {
            return this.initialCount;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    static class MailboxPathV3MigrationTask
    implements Task {
        private final MailboxPathV3Migration migration;

        MailboxPathV3MigrationTask(MailboxPathV3Migration migration) {
            this.migration = migration;
        }

        public Task.Result run() throws InterruptedException {
            return this.migration.runTask();
        }

        public TaskType type() {
            return TYPE;
        }

        public Optional<TaskExecutionDetails.AdditionalInformation> details() {
            return Optional.of(this.migration.getAdditionalInformation());
        }
    }
}

