/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.task.MailboxMergingTask;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;

public class MailboxMergingTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private static CassandraId.Factory ID_FACTORY = new CassandraId.Factory();
    private final String type;
    private final String oldMailboxId;
    private final String newMailboxId;
    private final long totalMessageCount;
    private final long messageMovedCount;
    private final long messageFailedCount;
    private final Instant timestamp;

    private static MailboxMergingTaskAdditionalInformationDTO fromDomainObject(MailboxMergingTask.Details details, String type) {
        return new MailboxMergingTaskAdditionalInformationDTO(type, details.getOldMailboxId(), details.getNewMailboxId(), details.getTotalMessageCount(), details.getMessageMovedCount(), details.getMessageFailedCount(), details.timestamp());
    }

    public static AdditionalInformationDTOModule<MailboxMergingTask.Details, MailboxMergingTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(MailboxMergingTask.Details.class).convertToDTO(MailboxMergingTaskAdditionalInformationDTO.class).toDomainObjectConverter(MailboxMergingTaskAdditionalInformationDTO::toDomainObject).toDTOConverter(MailboxMergingTaskAdditionalInformationDTO::fromDomainObject).typeName(MailboxMergingTask.MAILBOX_MERGING.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    public MailboxMergingTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="oldMailboxId") String oldMailboxId, @JsonProperty(value="newMailboxId") String newMailboxId, @JsonProperty(value="totalMessageCount") long totalMessageCount, @JsonProperty(value="messageMovedCount") long messageMovedCount, @JsonProperty(value="messageFailedCount") long messageFailedCount, @JsonProperty(value="timestamp") Instant timestamp) {
        this.type = type;
        this.oldMailboxId = oldMailboxId;
        this.newMailboxId = newMailboxId;
        this.totalMessageCount = totalMessageCount;
        this.messageMovedCount = messageMovedCount;
        this.messageFailedCount = messageFailedCount;
        this.timestamp = timestamp;
    }

    public String getOldMailboxId() {
        return this.oldMailboxId;
    }

    public String getNewMailboxId() {
        return this.newMailboxId;
    }

    public long getTotalMessageCount() {
        return this.totalMessageCount;
    }

    public long getMessageMovedCount() {
        return this.messageMovedCount;
    }

    public long getMessageFailedCount() {
        return this.messageFailedCount;
    }

    public String getType() {
        return this.type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    private MailboxMergingTask.Details toDomainObject() {
        return new MailboxMergingTask.Details(ID_FACTORY.fromString(this.oldMailboxId), ID_FACTORY.fromString(this.newMailboxId), this.totalMessageCount, this.messageMovedCount, this.messageFailedCount, this.timestamp);
    }
}

