/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.quota;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.cassandra.quota.QuotaCodec;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;

public class CassandraGlobalMaxQuotaDao {
    private final CassandraAsyncExecutor queryExecutor;
    private final PreparedStatement setGlobalMaxStorageStatement;
    private final PreparedStatement setGlobalMaxMessageStatement;
    private final PreparedStatement getGlobalMaxStatement;
    private final PreparedStatement removeGlobalMaxQuotaStatement;

    @Inject
    public CassandraGlobalMaxQuotaDao(Session session) {
        this.queryExecutor = new CassandraAsyncExecutor(session);
        this.getGlobalMaxStatement = session.prepare((RegularStatement)this.getGlobalMaxStatement());
        this.setGlobalMaxMessageStatement = session.prepare((RegularStatement)this.setGlobalMaxMessageStatement());
        this.setGlobalMaxStorageStatement = session.prepare((RegularStatement)this.setGlobalMaxStorageStatement());
        this.removeGlobalMaxQuotaStatement = session.prepare((RegularStatement)this.removeGlobalMaxQuotaStatement());
    }

    private Delete.Where removeGlobalMaxQuotaStatement() {
        return QueryBuilder.delete().all().from("defaultMaxQuota").where(QueryBuilder.eq((String)"type", (Object)QueryBuilder.bindMarker((String)"type")));
    }

    private Insert setGlobalMaxStorageStatement() {
        return QueryBuilder.insertInto((String)"defaultMaxQuota").value("type", (Object)"storage").value("value", (Object)QueryBuilder.bindMarker());
    }

    private Insert setGlobalMaxMessageStatement() {
        return QueryBuilder.insertInto((String)"defaultMaxQuota").value("type", (Object)"message").value("value", (Object)QueryBuilder.bindMarker());
    }

    private Select.Where getGlobalMaxStatement() {
        return QueryBuilder.select((String[])new String[]{"value"}).from("defaultMaxQuota").where(QueryBuilder.eq((String)"type", (Object)QueryBuilder.bindMarker((String)"type")));
    }

    Mono<Void> setGlobalMaxStorage(QuotaSizeLimit globalMaxStorage) {
        return this.queryExecutor.executeVoid((Statement)this.setGlobalMaxStorageStatement.bind(new Object[]{QuotaCodec.quotaValueToLong(globalMaxStorage)}));
    }

    Mono<Void> setGlobalMaxMessage(QuotaCountLimit globalMaxMessageCount) {
        return this.queryExecutor.executeVoid((Statement)this.setGlobalMaxMessageStatement.bind(new Object[]{QuotaCodec.quotaValueToLong(globalMaxMessageCount)}));
    }

    Mono<QuotaSizeLimit> getGlobalMaxStorage() {
        return this.queryExecutor.executeSingleRow((Statement)this.getGlobalMaxStatement.bind().setString("type", "storage")).map(row -> Optional.ofNullable((Long)row.get("value", Long.class))).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaSize).handle(ReactorUtils.publishIfPresent());
    }

    Mono<QuotaCountLimit> getGlobalMaxMessage() {
        return this.queryExecutor.executeSingleRow((Statement)this.getGlobalMaxStatement.bind().setString("type", "message")).map(row -> Optional.ofNullable((Long)row.get("value", Long.class))).handle(ReactorUtils.publishIfPresent()).map(QuotaCodec::longToQuotaCount).handle(ReactorUtils.publishIfPresent());
    }

    Mono<Void> removeGlobaltMaxStorage() {
        return this.queryExecutor.executeVoid((Statement)this.removeGlobalMaxQuotaStatement.bind(new Object[]{"storage"}));
    }

    Mono<Void> removeGlobalMaxMessage() {
        return this.queryExecutor.executeVoid((Statement)this.removeGlobalMaxQuotaStatement.bind(new Object[]{"message"}));
    }
}

