/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.hbase;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseClusterSingleton {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseClusterSingleton.class);
    private static final HBaseTestingUtility htu = new HBaseTestingUtility();
    private static HBaseClusterSingleton cluster = null;
    private MiniHBaseCluster hbaseCluster;
    private Configuration conf;

    public static synchronized HBaseClusterSingleton build() throws RuntimeException {
        LOG.info("Retrieving cluster instance.");
        if (cluster == null) {
            cluster = new HBaseClusterSingleton();
        }
        return cluster;
    }

    private HBaseClusterSingleton() throws RuntimeException {
        try {
            Process process = Runtime.getRuntime().exec("/bin/sh -c umask");
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            int rc = process.waitFor();
            if (rc == 0) {
                String umask = br.readLine();
                int umaskBits = Integer.parseInt(umask, 8);
                int permBits = 0x1FF & ~umaskBits;
                String perms = Integer.toString(permBits, 8);
                LOG.info("Setting dfs.datanode.data.dir.perm to " + perms);
                htu.getConfiguration().set("dfs.datanode.data.dir.perm", perms);
            } else {
                LOG.warn("Failed running umask command in a shell, nonzero return value");
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't get umask", (Throwable)e);
        }
        htu.getConfiguration().setBoolean("dfs.support.append", true);
        htu.getConfiguration().setInt("zookeeper.session.timeout", 20000);
        try {
            this.hbaseCluster = htu.startMiniCluster();
            LOG.info("After cluster start-up.");
            this.hbaseCluster.waitForActiveAndReadyMaster();
            LOG.info("After active and ready.");
            this.conf = this.hbaseCluster.getConfiguration();
            if (this.hbaseCluster != null) {
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HBaseClusterSingleton.this.hbaseCluster.shutdown();
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Exception shuting down cluster.");
                        }
                    }
                }));
            }
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Minicluster not starting.");
            }
            catch (Throwable throwable) {
                if (this.hbaseCluster != null) {
                    Runtime.getRuntime().addShutdownHook(new Thread(new /* invalid duplicate definition of identical inner class */));
                }
                throw throwable;
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void ensureTable(String tableName, String ... columnFamilies) throws IOException {
        byte[][] cfs = new byte[columnFamilies.length][];
        for (int i = 0; i < columnFamilies.length; ++i) {
            cfs[i] = Bytes.toBytes((String)columnFamilies[i]);
        }
        this.ensureTable(Bytes.toBytes((String)tableName), cfs);
    }

    public void ensureTable(byte[] tableName, byte[][] cfs) throws IOException {
        HBaseAdmin admin = htu.getHBaseAdmin();
        if (!admin.tableExists(tableName)) {
            htu.createTable(tableName, cfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTable(String tableName) {
        HTable table = null;
        ResultScanner scanner = null;
        try {
            Result result;
            table = new HTable(this.conf, tableName);
            Scan scan = new Scan();
            scan.setCaching(1000);
            scanner = table.getScanner(scan);
            while ((result = scanner.next()) != null) {
                Delete delete = new Delete(result.getRow());
                table.delete(delete);
            }
        }
        catch (IOException ex) {
            try {
                LOG.info("Exception clearing table {}", (Object)tableName);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(scanner);
                IOUtils.closeStream(table);
                throw throwable;
            }
            IOUtils.closeStream(scanner);
            IOUtils.closeStream((Closeable)table);
        }
        IOUtils.closeStream((Closeable)scanner);
        IOUtils.closeStream((Closeable)table);
    }
}

