/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.hbase;

import java.util.UUID;
import org.apache.james.mailbox.hbase.HBaseId;
import org.apache.james.mailbox.hbase.HBaseMailboxIdDeserializer;
import org.apache.james.mailbox.store.mail.model.MailboxIdDeserialisationException;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class HBaseMailboxIdDeserializerTest {
    private static final String UUID_STRING = "5530370f-44c6-4647-990e-7768ce5131d4";
    private static final String MALFORMED_UUID_STRING = "xyz";
    private static final HBaseId HBASE_ID = HBaseId.of((UUID)UUID.fromString("5530370f-44c6-4647-990e-7768ce5131d4"));
    private HBaseMailboxIdDeserializer mailboxIdDeserializer;

    @Before
    public void setUp() {
        this.mailboxIdDeserializer = new HBaseMailboxIdDeserializer();
    }

    @Test
    public void deserializeShouldWork() throws Exception {
        Assertions.assertThat((Object)this.mailboxIdDeserializer.deserialize(UUID_STRING)).isEqualTo((Object)HBASE_ID);
    }

    @Test(expected=MailboxIdDeserialisationException.class)
    public void deserializeShouldThrowOnMalformedData() throws Exception {
        this.mailboxIdDeserializer.deserialize(MALFORMED_UUID_STRING);
    }
}

