/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.hbase.HBaseClusterSingleton;
import org.apache.james.mailbox.hbase.HBaseMailboxSessionMapperFactory;
import org.apache.james.mailbox.hbase.HBaseNames;
import org.apache.james.mailbox.hbase.mail.HBaseModSeqProvider;
import org.apache.james.mailbox.hbase.mail.HBaseUidProvider;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseMailboxSessionMapperFactoryTest {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseMailboxSessionMapperFactoryTest.class);
    private static final HBaseClusterSingleton CLUSTER = HBaseClusterSingleton.build();
    private static Configuration conf;

    @Before
    public void beforeMethod() throws IOException {
        this.ensureTables();
        this.clearTables();
        conf = CLUSTER.getConf();
    }

    private void ensureTables() throws IOException {
        CLUSTER.ensureTable(HBaseNames.MAILBOXES_TABLE, new byte[][]{HBaseNames.MAILBOX_CF});
        CLUSTER.ensureTable(HBaseNames.MESSAGES_TABLE, new byte[][]{HBaseNames.MESSAGES_META_CF, HBaseNames.MESSAGE_DATA_HEADERS_CF, HBaseNames.MESSAGE_DATA_BODY_CF});
        CLUSTER.ensureTable(HBaseNames.SUBSCRIPTIONS_TABLE, new byte[][]{HBaseNames.SUBSCRIPTION_CF});
    }

    private void clearTables() {
        CLUSTER.clearTable("JAMES_MAILBOXES");
        CLUSTER.clearTable("JAMES_MESSAGES");
        CLUSTER.clearTable("JAMES_SUBSCRIPTIONS");
    }

    @Test
    public void testCreateMessageMapper() throws Exception {
        LOG.info("createMessageMapper");
        MailboxSession session = null;
        MessageId.Factory messageIdFactory = null;
        HBaseMailboxSessionMapperFactory instance = new HBaseMailboxSessionMapperFactory(conf, null, null, messageIdFactory);
        MessageMapper messageMapper = instance.createMessageMapper(session);
        Assert.assertNotNull((Object)messageMapper);
        Assert.assertTrue((boolean)(messageMapper instanceof MessageMapper));
    }

    @Test
    public void testCreateMailboxMapper() throws Exception {
        LOG.info("createMailboxMapper");
        MailboxSession session = null;
        MessageId.Factory messageIdFactory = null;
        HBaseMailboxSessionMapperFactory instance = new HBaseMailboxSessionMapperFactory(conf, null, null, messageIdFactory);
        MailboxMapper mailboxMapper = instance.createMailboxMapper(session);
        Assert.assertNotNull((Object)mailboxMapper);
        Assert.assertTrue((boolean)(mailboxMapper instanceof MailboxMapper));
    }

    @Test
    public void testCreateSubscriptionMapper() throws Exception {
        LOG.info("createSubscriptionMapper");
        MailboxSession session = null;
        MessageId.Factory messageIdFactory = null;
        HBaseMailboxSessionMapperFactory instance = new HBaseMailboxSessionMapperFactory(conf, null, null, messageIdFactory);
        SubscriptionMapper subscriptionMapper = instance.createSubscriptionMapper(session);
        Assert.assertNotNull((Object)subscriptionMapper);
        Assert.assertTrue((boolean)(subscriptionMapper instanceof SubscriptionMapper));
    }

    @Test
    public void testGetModSeqProvider() {
        LOG.info("getModSeqProvider");
        HBaseModSeqProvider expResult = new HBaseModSeqProvider(conf);
        MessageId.Factory messageIdFactory = null;
        HBaseMailboxSessionMapperFactory instance = new HBaseMailboxSessionMapperFactory(conf, null, (ModSeqProvider)expResult, messageIdFactory);
        ModSeqProvider result = instance.getModSeqProvider();
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testGetUidProvider() {
        LOG.info("getUidProvider");
        HBaseUidProvider expResult = new HBaseUidProvider(conf);
        MessageId.Factory messageIdFactory = null;
        HBaseMailboxSessionMapperFactory instance = new HBaseMailboxSessionMapperFactory(conf, (UidProvider)expResult, null, messageIdFactory);
        UidProvider result = instance.getUidProvider();
        Assert.assertEquals((Object)expResult, (Object)result);
    }
}

