/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.hbase;

import java.util.Date;
import java.util.UUID;
import javax.mail.Flags;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.hbase.FlagConvertor;
import org.apache.james.mailbox.hbase.HBaseId;
import org.apache.james.mailbox.hbase.HBaseNames;
import org.apache.james.mailbox.hbase.HBaseUtils;
import org.apache.james.mailbox.hbase.PropertyConvertor;
import org.apache.james.mailbox.hbase.mail.model.HBaseMailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.SimpleProperty;
import org.apache.james.mailbox.store.user.model.Subscription;
import org.apache.james.mailbox.store.user.model.impl.SimpleSubscription;
import org.junit.Assert;
import org.junit.Test;

public class HBaseUtilsTest {
    @Test
    public void testRowKey_All() {
        System.out.println("getRowKey and UUIDFromRowKey");
        HBaseMailbox mailbox = new HBaseMailbox(new MailboxPath("gsoc", "ieugen", "INBOX"), 1234L);
        HBaseId uuid = mailbox.getMailboxId();
        byte[] expResult = uuid.toBytes();
        byte[] result = mailbox.getMailboxId().toBytes();
        Assert.assertArrayEquals((byte[])expResult, (byte[])result);
        HBaseId newUUID = HBaseUtils.HBaseIdFromRowKey((byte[])result);
        Assert.assertEquals((Object)uuid, (Object)newUUID);
        newUUID = HBaseUtils.HBaseIdFromRowKey((byte[])expResult);
        Assert.assertEquals((Object)uuid, (Object)newUUID);
    }

    @Test
    public void testMailboxToPut() {
        System.out.println("mailboxToPut");
        HBaseMailbox instance = new HBaseMailbox(new MailboxPath("gsoc", "ieugen", "INBOX"), 1234L);
        Put result = HBaseUtils.toPut((HBaseMailbox)instance);
        Assert.assertArrayEquals((byte[])instance.getMailboxId().toBytes(), (byte[])result.getRow());
        Assert.assertTrue((boolean)result.has(HBaseNames.MAILBOX_CF, HBaseNames.MAILBOX_USER, Bytes.toBytes((String)instance.getUser())));
        Assert.assertTrue((boolean)result.has(HBaseNames.MAILBOX_CF, HBaseNames.MAILBOX_NAME, Bytes.toBytes((String)instance.getName())));
        Assert.assertTrue((boolean)result.has(HBaseNames.MAILBOX_CF, HBaseNames.MAILBOX_NAMESPACE, Bytes.toBytes((String)instance.getNamespace())));
        Assert.assertTrue((boolean)result.has(HBaseNames.MAILBOX_CF, HBaseNames.MAILBOX_UIDVALIDITY, Bytes.toBytes((long)instance.getUidValidity())));
        Assert.assertTrue((boolean)result.has(HBaseNames.MAILBOX_CF, HBaseNames.MAILBOX_LASTUID, Bytes.toBytes((long)instance.getLastUid())));
        Assert.assertTrue((boolean)result.has(HBaseNames.MAILBOX_CF, HBaseNames.MAILBOX_HIGHEST_MODSEQ, Bytes.toBytes((long)instance.getHighestModSeq())));
        Assert.assertTrue((boolean)result.has(HBaseNames.MAILBOX_CF, HBaseNames.MAILBOX_MESSAGE_COUNT, Bytes.toBytes((long)0L)));
    }

    public void testMessageToPut() {
        System.out.println("messageToPut");
    }

    @Test
    public void testPropertyToBytes() {
        SimpleProperty prop1 = new SimpleProperty("nspace", "localName", "test");
        byte[] value = PropertyConvertor.getValue((Property)prop1);
        Property prop2 = PropertyConvertor.getProperty((byte[])value);
        Assert.assertEquals((Object)prop1.getNamespace(), (Object)prop2.getNamespace());
        Assert.assertEquals((Object)prop1.getLocalName(), (Object)prop2.getLocalName());
        Assert.assertEquals((Object)prop1.getValue(), (Object)prop2.getValue());
    }

    @Test
    public void testSubscriptionToPut() {
        System.out.println("subscription toPut");
        SimpleSubscription subscription = new SimpleSubscription("ieugen", "INBOX");
        Put put = HBaseUtils.toPut((Subscription)subscription);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)subscription.getUser()), (byte[])put.getRow());
        Assert.assertTrue((boolean)put.has(HBaseNames.SUBSCRIPTION_CF, Bytes.toBytes((String)subscription.getMailbox()), HBaseNames.MARKER_PRESENT));
    }

    @Test
    public void testFlagsToPut() {
        System.out.println("flagsToPut");
        Flags flags = new Flags();
        flags.add(Flags.Flag.SEEN);
        flags.add(Flags.Flag.DRAFT);
        flags.add(Flags.Flag.RECENT);
        flags.add(Flags.Flag.FLAGGED);
        flags.add("userFlag1");
        flags.add("userFlag2");
        HBaseId uuid = HBaseId.of((UUID)UUID.randomUUID());
        DefaultMessageId messageId = new DefaultMessageId();
        SimpleMailboxMessage message = new SimpleMailboxMessage((MessageId)messageId, new Date(), 100L, 10, null, flags, new PropertyBuilder(), (MailboxId)uuid);
        message.setUid(MessageUid.of((long)1L));
        Put put = HBaseUtils.flagsToPut((MailboxMessage)message, (Flags)flags);
        Assert.assertTrue((boolean)put.has(HBaseNames.MESSAGES_META_CF, FlagConvertor.FLAGS_SEEN, HBaseNames.MARKER_PRESENT));
        Assert.assertTrue((boolean)put.has(HBaseNames.MESSAGES_META_CF, FlagConvertor.FLAGS_DRAFT, HBaseNames.MARKER_PRESENT));
        Assert.assertTrue((boolean)put.has(HBaseNames.MESSAGES_META_CF, FlagConvertor.FLAGS_RECENT, HBaseNames.MARKER_PRESENT));
        Assert.assertTrue((boolean)put.has(HBaseNames.MESSAGES_META_CF, FlagConvertor.FLAGS_FLAGGED, HBaseNames.MARKER_PRESENT));
        Assert.assertTrue((boolean)put.has(HBaseNames.MESSAGES_META_CF, FlagConvertor.FLAGS_ANSWERED, HBaseNames.MARKER_MISSING));
        Assert.assertTrue((boolean)put.has(HBaseNames.MESSAGES_META_CF, FlagConvertor.FLAGS_DELETED, HBaseNames.MARKER_MISSING));
        Assert.assertTrue((boolean)put.has(HBaseNames.MESSAGES_META_CF, FlagConvertor.userFlagToBytes((String)"userFlag1"), HBaseNames.MARKER_PRESENT));
        Assert.assertTrue((boolean)put.has(HBaseNames.MESSAGES_META_CF, FlagConvertor.userFlagToBytes((String)"userFlag2"), HBaseNames.MARKER_PRESENT));
    }
}

