/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.hbase.mail.model;

import java.util.UUID;
import org.apache.james.mailbox.hbase.HBaseId;
import org.apache.james.mailbox.hbase.mail.model.HBaseMailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.junit.Assert;
import org.junit.Test;

public class HBaseMailboxTest {
    @Test
    public void testGetSetMailboxId() {
        System.out.println("getSetMailboxId");
        MailboxPath mailboxPath = new MailboxPath("gsoc", "ieugen", "INBOX");
        HBaseMailbox instance = new HBaseMailbox(mailboxPath, 10L);
        HBaseId expResult = HBaseId.of((UUID)UUID.randomUUID());
        instance.setMailboxId((MailboxId)expResult);
        Assert.assertEquals((Object)expResult, (Object)instance.getMailboxId());
    }

    @Test
    public void testGetSetNamespace() {
        System.out.println("getSetNamespace");
        MailboxPath mailboxPath = new MailboxPath("gsoc", "ieugen", "INBOX");
        HBaseMailbox instance = new HBaseMailbox(mailboxPath, 124566L);
        String result = instance.getNamespace();
        Assert.assertEquals((Object)mailboxPath.getNamespace(), (Object)result);
        instance.setNamespace("newName");
        Assert.assertEquals((Object)"newName", (Object)instance.getNamespace());
    }

    @Test
    public void testGetSetUser() {
        System.out.println("getUser");
        MailboxPath mailboxPath = new MailboxPath("gsoc", "ieugen", "INBOX");
        HBaseMailbox instance = new HBaseMailbox(mailboxPath, 12L);
        String result = instance.getUser();
        Assert.assertEquals((Object)mailboxPath.getUser(), (Object)result);
        instance.setUser("eric");
        Assert.assertEquals((Object)"eric", (Object)instance.getUser());
    }

    @Test
    public void testGetSetName() {
        System.out.println("getSetName");
        MailboxPath mailboxPath = new MailboxPath("gsoc", "ieugen", "INBOX");
        HBaseMailbox instance = new HBaseMailbox(mailboxPath, 1677L);
        String result = instance.getName();
        Assert.assertEquals((Object)mailboxPath.getName(), (Object)result);
        instance.setName("newINBOX");
        Assert.assertEquals((Object)"newINBOX", (Object)instance.getName());
    }

    @Test
    public void testGetUidValidity() {
        System.out.println("getUidValidity");
        MailboxPath mailboxPath = new MailboxPath("gsoc", "ieugen", "INBOX");
        HBaseMailbox instance = new HBaseMailbox(mailboxPath, 123345L);
        long expResult = 123345L;
        long result = instance.getUidValidity();
        Assert.assertEquals((long)expResult, (long)result);
    }

    @Test
    public void testHashCode() {
        System.out.println("hashCode");
        MailboxPath mailboxPath = new MailboxPath("gsoc", "ieugen", "INBOX");
        HBaseMailbox instance = new HBaseMailbox(mailboxPath, 1234L);
        int PRIME = 31;
        int result = 1;
        HBaseId mailboxId = instance.getMailboxId();
        int expResult = 31 * result + (int)(mailboxId.getRawId().getMostSignificantBits() ^ mailboxId.getRawId().getMostSignificantBits() >>> 32);
        Assert.assertEquals((long)expResult, (long)instance.hashCode());
    }

    @Test
    public void testEquals() {
        System.out.println("equals");
        MailboxPath mailboxPath = new MailboxPath("gsoc", "ieugen", "INBOX");
        HBaseMailbox instance = new HBaseMailbox(mailboxPath, 12345L);
        HBaseMailbox instance2 = new HBaseMailbox(mailboxPath, 12345L);
        instance2.setMailboxId((MailboxId)instance.getMailboxId());
        Assert.assertEquals((Object)instance, (Object)instance2);
    }

    @Test
    public void testConsumeUid() {
        System.out.println("consumeUid");
        MailboxPath mailboxPath = new MailboxPath("gsoc", "ieugen", "INBOX");
        HBaseMailbox instance = new HBaseMailbox(mailboxPath, 10L);
        long expResult = instance.getLastUid() + 1L;
        long result = instance.consumeUid();
        Assert.assertEquals((long)expResult, (long)result);
    }

    @Test
    public void testConsumeModSeq() {
        System.out.println("consumeModSeq");
        MailboxPath mailboxPath = new MailboxPath("gsoc", "ieugen", "INBOX");
        HBaseMailbox instance = new HBaseMailbox(mailboxPath, 10L);
        long expResult = instance.getHighestModSeq() + 1L;
        long result = instance.consumeModSeq();
        Assert.assertEquals((long)expResult, (long)result);
    }
}

