/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.hbase.user;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.hbase.HBaseClusterSingleton;
import org.apache.james.mailbox.hbase.HBaseMailboxSessionMapperFactory;
import org.apache.james.mailbox.hbase.HBaseNames;
import org.apache.james.mailbox.hbase.user.HBaseSubscriptionMapper;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.DefaultMessageId;
import org.apache.james.mailbox.store.user.model.Subscription;
import org.apache.james.mailbox.store.user.model.impl.SimpleSubscription;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseSubscriptionMapperTest {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseSubscriptionMapperTest.class);
    private static final HBaseClusterSingleton CLUSTER = HBaseClusterSingleton.build();
    private static Configuration conf;
    private static HBaseMailboxSessionMapperFactory mapperFactory;
    private static HBaseSubscriptionMapper mapper;
    private static Map<String, List<SimpleSubscription>> subscriptionList;
    private static final int USERS = 5;
    private static final int MAILBOX_NO = 5;

    @Before
    public void setUp() throws Exception {
        this.ensureTables();
        this.clearTables();
        conf = CLUSTER.getConf();
        DefaultMessageId.Factory messageIdFactory = new DefaultMessageId.Factory();
        mapperFactory = new HBaseMailboxSessionMapperFactory(conf, null, null, (MessageId.Factory)messageIdFactory);
        mapper = new HBaseSubscriptionMapper(conf);
        HBaseSubscriptionMapperTest.fillSubscriptionList();
    }

    private void ensureTables() throws IOException {
        CLUSTER.ensureTable(HBaseNames.MAILBOXES_TABLE, new byte[][]{HBaseNames.MAILBOX_CF});
        CLUSTER.ensureTable(HBaseNames.MESSAGES_TABLE, new byte[][]{HBaseNames.MESSAGES_META_CF, HBaseNames.MESSAGE_DATA_HEADERS_CF, HBaseNames.MESSAGE_DATA_BODY_CF});
        CLUSTER.ensureTable(HBaseNames.SUBSCRIPTIONS_TABLE, new byte[][]{HBaseNames.SUBSCRIPTION_CF});
    }

    private void clearTables() {
        CLUSTER.clearTable("JAMES_MAILBOXES");
        CLUSTER.clearTable("JAMES_MESSAGES");
        CLUSTER.clearTable("JAMES_SUBSCRIPTIONS");
    }

    private static void fillSubscriptionList() throws SubscriptionException {
        LOG.info("Creating subscription list");
        subscriptionList = new HashMap<String, List<SimpleSubscription>>();
        for (int i = 0; i < 5; ++i) {
            String user = "user" + i;
            ArrayList<SimpleSubscription> mailboxes = new ArrayList<SimpleSubscription>();
            subscriptionList.put(user, mailboxes);
            for (int j = 0; j < 5; ++j) {
                String mailbox = j == 0 ? "INBOX" : "BOX" + j;
                if (i % 2 == 0 && j > 0) continue;
                SimpleSubscription subscription = new SimpleSubscription(user, mailbox);
                mailboxes.add(subscription);
                mapper.save((Subscription)subscription);
                LOG.info("Adding subscription " + subscription);
            }
        }
    }

    @Test
    public void testFindMailboxSubscriptionForUser() throws Exception {
        LOG.info("findMailboxSubscriptionForUser");
        SimpleSubscription fake1 = new SimpleSubscription("user1", "FAKEBOX");
        SimpleSubscription fake2 = new SimpleSubscription("fakeUser", "INBOX");
        for (String user : subscriptionList.keySet()) {
            LOG.info("Searching for all subscriptions for user:{}", (Object)user);
            for (SimpleSubscription subscription : subscriptionList.get(user)) {
                Subscription result = mapper.findMailboxSubscriptionForUser(user, subscription.getMailbox());
                Assert.assertEquals((Object)subscription.getMailbox(), (Object)result.getMailbox());
                Assert.assertEquals((Object)subscription.getUser(), (Object)result.getUser());
            }
        }
        Assert.assertNull((Object)mapper.findMailboxSubscriptionForUser(fake1.getUser(), fake1.getMailbox()));
        Assert.assertNull((Object)mapper.findMailboxSubscriptionForUser(fake2.getUser(), fake2.getMailbox()));
    }

    @Test
    public void testSave() throws Exception {
        LOG.info("save");
        HTable subscriptions = new HTable(mapperFactory.getClusterConfiguration(), HBaseNames.SUBSCRIPTIONS_TABLE);
        for (String user : subscriptionList.keySet()) {
            Get get = new Get(Bytes.toBytes((String)user));
            get.addFamily(HBaseNames.SUBSCRIPTION_CF);
            Result result = subscriptions.get(get);
            for (Subscription subscription : subscriptionList.get(user)) {
                Assert.assertTrue((boolean)result.containsColumn(HBaseNames.SUBSCRIPTION_CF, Bytes.toBytes((String)subscription.getMailbox())));
            }
        }
        subscriptions.close();
    }

    @Test
    public void testFindSubscriptionsForUser() throws Exception {
        LOG.info("findSubscriptionsForUser");
        SimpleSubscription fake1 = new SimpleSubscription("user1", "FAKEBOX");
        SimpleSubscription fake2 = new SimpleSubscription("fakeUser", "INBOX");
        for (String user : subscriptionList.keySet()) {
            LOG.info("Searching for all subscriptions for user: " + user);
            List found = mapper.findSubscriptionsForUser(user);
            Assert.assertEquals((long)subscriptionList.get(user).size(), (long)found.size());
        }
        Assert.assertEquals((long)mapper.findSubscriptionsForUser(fake2.getMailbox()).size(), (long)0L);
    }

    @Test
    public void testDelete() throws Exception {
        LOG.info("delete");
        HTable subscriptions = new HTable(mapperFactory.getClusterConfiguration(), HBaseNames.SUBSCRIPTIONS_TABLE);
        for (String user : subscriptionList.keySet()) {
            LOG.info("Deleting subscriptions for user: " + user);
            for (SimpleSubscription subscription : subscriptionList.get(user)) {
                LOG.info("Deleting subscription : " + subscription);
                mapper.delete((Subscription)subscription);
                Get get = new Get(Bytes.toBytes((String)subscription.getUser()));
                Result result = subscriptions.get(get);
                Assert.assertFalse((boolean)result.containsColumn(HBaseNames.SUBSCRIPTION_CF, Bytes.toBytes((String)subscription.getMailbox())));
            }
        }
        subscriptions.close();
        HBaseSubscriptionMapperTest.fillSubscriptionList();
    }
}

