/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory;

import java.util.EnumSet;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.inmemory.InMemoryMessageManager;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.event.DelegatingMailboxListener;
import org.apache.james.mailbox.store.event.MailboxEventDispatcher;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.search.MessageSearchIndex;

public class InMemoryMailboxManager
extends StoreMailboxManager {
    public static final EnumSet<MailboxManager.MailboxCapabilities> MAILBOX_CAPABILITIES = EnumSet.of(MailboxManager.MailboxCapabilities.Move, new MailboxManager.MailboxCapabilities[]{MailboxManager.MailboxCapabilities.UserFlag, MailboxManager.MailboxCapabilities.Namespace, MailboxManager.MailboxCapabilities.Annotation, MailboxManager.MailboxCapabilities.ACL, MailboxManager.MailboxCapabilities.Quota});
    public static final EnumSet<MailboxManager.MessageCapabilities> MESSAGE_CAPABILITIES = EnumSet.of(MailboxManager.MessageCapabilities.UniqueID);

    @Inject
    public InMemoryMailboxManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxPathLocker locker, MessageParser messageParser, MessageId.Factory messageIdFactory, MailboxEventDispatcher dispatcher, DelegatingMailboxListener delegatingMailboxListener, StoreMailboxAnnotationManager annotationManager, StoreRightManager storeRightManager) {
        super(mailboxSessionMapperFactory, authenticator, authorizator, locker, messageParser, messageIdFactory, (MailboxAnnotationManager)annotationManager, dispatcher, delegatingMailboxListener, storeRightManager);
    }

    @Inject
    public void setMessageSearchIndex(MessageSearchIndex index) {
        super.setMessageSearchIndex(index);
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return MAILBOX_CAPABILITIES;
    }

    public EnumSet<MailboxManager.MessageCapabilities> getSupportedMessageCapabilities() {
        return MESSAGE_CAPABILITIES;
    }

    protected StoreMessageManager createMessageManager(Mailbox mailbox, MailboxSession session) {
        return new InMemoryMessageManager(this.getMapperFactory(), this.getMessageSearchIndex(), this.getEventDispatcher(), this.getLocker(), mailbox, this.getQuotaManager(), this.getQuotaRootResolver(), this.getMessageParser(), this.getMessageIdFactory(), this.getBatchSizes(), this.getImmutableMailboxMessageFactory(), this.getStoreRightManager());
    }
}

