/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MailboxSessionUtil;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.inmemory.InMemoryMailboxSessionMapperFactory;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.inmemory.mail.InMemoryMessageIdMapper;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.AttachmentMapper;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MapperProvider;
import org.apache.james.mailbox.store.mail.model.MessageUidProvider;

public class InMemoryMapperProvider
implements MapperProvider {
    private static final Username USER = Username.of((String)"user");
    private static final MailboxSession MAILBOX_SESSION = MailboxSessionUtil.create((Username)USER);
    private final MessageId.Factory messageIdFactory = new InMemoryMessageId.Factory();
    private final MessageUidProvider messageUidProvider = new MessageUidProvider();
    private final InMemoryMailboxSessionMapperFactory inMemoryMailboxSessionMapperFactory = new InMemoryMailboxSessionMapperFactory();

    public MailboxMapper createMailboxMapper() throws MailboxException {
        return this.inMemoryMailboxSessionMapperFactory.createMailboxMapper(MAILBOX_SESSION);
    }

    public MessageMapper createMessageMapper() throws MailboxException {
        return this.inMemoryMailboxSessionMapperFactory.createMessageMapper(MailboxSessionUtil.create((Username)USER));
    }

    public MessageIdMapper createMessageIdMapper() throws MailboxException {
        return new InMemoryMessageIdMapper(this.inMemoryMailboxSessionMapperFactory.createMailboxMapper(MAILBOX_SESSION), this.inMemoryMailboxSessionMapperFactory.createMessageMapper(MAILBOX_SESSION));
    }

    public AttachmentMapper createAttachmentMapper() throws MailboxException {
        return this.inMemoryMailboxSessionMapperFactory.createAttachmentMapper(MAILBOX_SESSION);
    }

    public InMemoryId generateId() {
        return InMemoryId.of((long)ThreadLocalRandom.current().nextInt());
    }

    public MessageUid generateMessageUid() {
        return this.messageUidProvider.next();
    }

    public boolean supportPartialAttachmentFetch() {
        return false;
    }

    public MessageId generateMessageId() {
        return this.messageIdFactory.generate();
    }

    public List<MapperProvider.Capabilities> getSupportedCapabilities() {
        return ImmutableList.of((Object)MapperProvider.Capabilities.MESSAGE, (Object)MapperProvider.Capabilities.MAILBOX, (Object)MapperProvider.Capabilities.ATTACHMENT, (Object)MapperProvider.Capabilities.ANNOTATION, (Object)MapperProvider.Capabilities.MOVE, (Object)MapperProvider.Capabilities.ACL_STORAGE, (Object)MapperProvider.Capabilities.UNIQUE_MESSAGE_ID);
    }

    public ModSeq generateModSeq(Mailbox mailbox) throws MailboxException {
        return this.inMemoryMailboxSessionMapperFactory.getModSeqProvider().nextModSeq(mailbox);
    }

    public ModSeq highestModSeq(Mailbox mailbox) throws MailboxException {
        return this.inMemoryMailboxSessionMapperFactory.getModSeqProvider().highestModSeq(mailbox);
    }
}

