/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import java.io.InputStream;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.store.AbstractMailboxManagerAttachmentTest;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class InMemoryMailboxManagerAttachmentTest
extends AbstractMailboxManagerAttachmentTest {
    InMemoryMailboxManager mailboxManager;
    InMemoryMailboxManager parseFailingMailboxManager;

    InMemoryMailboxManagerAttachmentTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        MessageParser failingMessageParser = (MessageParser)Mockito.mock(MessageParser.class);
        Mockito.when((Object)failingMessageParser.retrieveAttachments((InputStream)ArgumentMatchers.any(InputStream.class))).thenThrow(new Throwable[]{new RuntimeException("Message parser set to fail")});
        this.mailboxManager = InMemoryIntegrationResources.defaultResources().getMailboxManager();
        this.parseFailingMailboxManager = InMemoryIntegrationResources.builder().preProvisionnedFakeAuthenticator().fakeAuthorizator().inVmEventBus().defaultAnnotationLimits().messageParser(failingMessageParser).scanningSearchIndex().noPreDeletionHooks().storeQuotaManager().build().getMailboxManager();
        super.setUp();
    }

    protected MailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    protected MailboxSessionMapperFactory getMailboxSessionMapperFactory() {
        return this.mailboxManager.getMapperFactory();
    }

    protected MailboxManager getParseFailingMailboxManager() {
        return this.parseFailingMailboxManager;
    }

    protected AttachmentMapperFactory getAttachmentMapperFactory() {
        return (AttachmentMapperFactory)this.mailboxManager.getMapperFactory();
    }
}

