/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail.task;

import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.inmemory.manager.InMemoryIntegrationResources;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasService;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasServiceContract;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;

class MemoryRecomputeCurrentQuotasServiceTest
implements RecomputeCurrentQuotasServiceContract {
    MemoryUsersRepository usersRepository;
    InMemoryIntegrationResources resources;
    RecomputeCurrentQuotasService testee;

    MemoryRecomputeCurrentQuotasServiceTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        DNSService dnsService = (DNSService)Mockito.mock(DNSService.class);
        MemoryDomainList memoryDomainList = new MemoryDomainList(dnsService);
        memoryDomainList.configure(DomainListConfiguration.builder().autoDetect(false).autoDetectIp(false).build());
        this.usersRepository = MemoryUsersRepository.withoutVirtualHosting((DomainList)memoryDomainList);
        this.resources = InMemoryIntegrationResources.defaultResources();
        this.testee = new RecomputeCurrentQuotasService((UsersRepository)this.usersRepository, (CurrentQuotaManager)this.resources.getCurrentQuotaManager(), this.resources.getCurrentQuotaCalculator(), (UserQuotaRootResolver)this.resources.getDefaultUserQuotaRootResolver(), this.resources.getMailboxManager().getSessionProvider());
    }

    public RecomputeCurrentQuotasService testee() {
        return this.testee;
    }

    public UsersRepository usersRepository() {
        return this.usersRepository;
    }

    public SessionProvider sessionProvider() {
        return this.resources.getMailboxManager().getSessionProvider();
    }

    public MailboxManager mailboxManager() {
        return this.resources.getMailboxManager();
    }

    public CurrentQuotaManager currentQuotaManager() {
        return this.resources.getCurrentQuotaManager();
    }

    public UserQuotaRootResolver userQuotaRootResolver() {
        return this.resources.getDefaultUserQuotaRootResolver();
    }
}

