/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventBusTestFixture;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventListener;
import org.apache.james.events.InVMEventBus;
import org.apache.james.events.MemoryEventDeadLetters;
import org.apache.james.events.delivery.EventDelivery;
import org.apache.james.events.delivery.InVmEventDelivery;
import org.apache.james.mailbox.AttachmentContentLoader;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.Authenticator;
import org.apache.james.mailbox.Authorizator;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.extension.PreDeletionHook;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.inmemory.InMemoryMailboxManager;
import org.apache.james.mailbox.inmemory.InMemoryMailboxSessionMapperFactory;
import org.apache.james.mailbox.inmemory.InMemoryMessageId;
import org.apache.james.mailbox.inmemory.quota.InMemoryCurrentQuotaManager;
import org.apache.james.mailbox.inmemory.quota.InMemoryPerUserMaxQuotaManager;
import org.apache.james.mailbox.manager.IntegrationResources;
import org.apache.james.mailbox.manager.ManagerTestProvisionner;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.FakeAuthenticator;
import org.apache.james.mailbox.store.FakeAuthorizator;
import org.apache.james.mailbox.store.JVMMailboxPathLocker;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.PreDeletionHooks;
import org.apache.james.mailbox.store.SessionProviderImpl;
import org.apache.james.mailbox.store.StoreAttachmentManager;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreMessageIdManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.event.MailboxAnnotationListener;
import org.apache.james.mailbox.store.extractor.DefaultTextExtractor;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapperFactory;
import org.apache.james.mailbox.store.mail.MessageMapperFactory;
import org.apache.james.mailbox.store.mail.NaiveThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.ThreadIdGuessingAlgorithm;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.quota.CurrentQuotaCalculator;
import org.apache.james.mailbox.store.quota.DefaultUserQuotaRootResolver;
import org.apache.james.mailbox.store.quota.ListeningCurrentQuotaUpdater;
import org.apache.james.mailbox.store.quota.QuotaComponents;
import org.apache.james.mailbox.store.quota.StoreQuotaManager;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.mailbox.store.search.SimpleMessageSearchIndex;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.tests.RecordingMetricFactory;

public class InMemoryIntegrationResources
implements IntegrationResources<StoreMailboxManager> {
    private final InMemoryMailboxManager mailboxManager;
    private final StoreRightManager storeRightManager;
    private final MessageId.Factory messageIdFactory;
    private final CurrentQuotaCalculator currentQuotaCalculator;
    private final InMemoryCurrentQuotaManager currentQuotaManager;
    private final DefaultUserQuotaRootResolver defaultUserQuotaRootResolver;
    private final InMemoryPerUserMaxQuotaManager maxQuotaManager;
    private final QuotaManager quotaManager;
    private final StoreMessageIdManager storeMessageIdManager;
    private final MessageSearchIndex searchIndex;
    private final EventBus eventBus;
    private final AttachmentManager attachmentManager;

    public static Stages.RequireAuthenticator builder() {
        return new Builder();
    }

    public static InMemoryIntegrationResources defaultResources() {
        return InMemoryIntegrationResources.builder().preProvisionnedFakeAuthenticator().fakeAuthorizator().inVmEventBus().defaultAnnotationLimits().defaultMessageParser().scanningSearchIndex().noPreDeletionHooks().storeQuotaManager().build();
    }

    InMemoryIntegrationResources(InMemoryMailboxManager mailboxManager, StoreRightManager storeRightManager, MessageId.Factory messageIdFactory, CurrentQuotaCalculator currentQuotaCalculator, InMemoryCurrentQuotaManager currentQuotaManager, DefaultUserQuotaRootResolver defaultUserQuotaRootResolver, InMemoryPerUserMaxQuotaManager maxQuotaManager, QuotaManager quotaManager, StoreMessageIdManager storeMessageIdManager, MessageSearchIndex searchIndex, EventBus eventBus, AttachmentManager attachmentManager) {
        this.mailboxManager = mailboxManager;
        this.storeRightManager = storeRightManager;
        this.messageIdFactory = messageIdFactory;
        this.currentQuotaCalculator = currentQuotaCalculator;
        this.currentQuotaManager = currentQuotaManager;
        this.defaultUserQuotaRootResolver = defaultUserQuotaRootResolver;
        this.maxQuotaManager = maxQuotaManager;
        this.quotaManager = quotaManager;
        this.storeMessageIdManager = storeMessageIdManager;
        this.searchIndex = searchIndex;
        this.eventBus = eventBus;
        this.attachmentManager = attachmentManager;
    }

    public DefaultUserQuotaRootResolver getDefaultUserQuotaRootResolver() {
        return this.defaultUserQuotaRootResolver;
    }

    public InMemoryMailboxManager getMailboxManager() {
        return this.mailboxManager;
    }

    public CurrentQuotaCalculator getCurrentQuotaCalculator() {
        return this.currentQuotaCalculator;
    }

    public InMemoryCurrentQuotaManager getCurrentQuotaManager() {
        return this.currentQuotaManager;
    }

    public StoreRightManager getStoreRightManager() {
        return this.storeRightManager;
    }

    public MessageId.Factory getMessageIdFactory() {
        return this.messageIdFactory;
    }

    public InMemoryPerUserMaxQuotaManager getMaxQuotaManager() {
        return this.maxQuotaManager;
    }

    public QuotaManager getQuotaManager() {
        return this.quotaManager;
    }

    public MessageIdManager getMessageIdManager() {
        return this.storeMessageIdManager;
    }

    public QuotaRootResolver getQuotaRootResolver() {
        return this.defaultUserQuotaRootResolver;
    }

    public MessageSearchIndex getSearchIndex() {
        return this.searchIndex;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public static class MailboxManagerSearchIndexStage {
        private final InMemoryMailboxSessionMapperFactory mapperFactory;
        private final SessionProvider sessionProvider;
        private final AttachmentContentLoader attachmentContentLoader;

        MailboxManagerSearchIndexStage(InMemoryMailboxSessionMapperFactory mapperFactory, SessionProvider sessionProvider, AttachmentContentLoader attachmentContentLoader) {
            this.mapperFactory = mapperFactory;
            this.sessionProvider = sessionProvider;
            this.attachmentContentLoader = attachmentContentLoader;
        }

        public InMemoryMailboxSessionMapperFactory getMapperFactory() {
            return this.mapperFactory;
        }

        public SessionProvider getSessionProvider() {
            return this.sessionProvider;
        }

        public AttachmentContentLoader getAttachmentContentLoader() {
            return this.attachmentContentLoader;
        }
    }

    public static class MailboxManagerPreInstanciationStage {
        private final InMemoryMailboxSessionMapperFactory mapperFactory;
        private final SessionProviderImpl sessionProvider;

        public MailboxManagerPreInstanciationStage(InMemoryMailboxSessionMapperFactory mapperFactory, SessionProviderImpl sessionProvider) {
            this.mapperFactory = mapperFactory;
            this.sessionProvider = sessionProvider;
        }

        public InMemoryMailboxSessionMapperFactory getMapperFactory() {
            return this.mapperFactory;
        }

        public SessionProviderImpl getSessionProvider() {
            return this.sessionProvider;
        }
    }

    public static class BaseQuotaComponentsStage {
        private final InMemoryPerUserMaxQuotaManager maxQuotaManager;
        private final InMemoryCurrentQuotaManager currentQuotaManager;

        public BaseQuotaComponentsStage(InMemoryPerUserMaxQuotaManager maxQuotaManager, InMemoryCurrentQuotaManager currentQuotaManager) {
            this.maxQuotaManager = maxQuotaManager;
            this.currentQuotaManager = currentQuotaManager;
        }

        public InMemoryPerUserMaxQuotaManager getMaxQuotaManager() {
            return this.maxQuotaManager;
        }

        public InMemoryCurrentQuotaManager getCurrentQuotaManager() {
            return this.currentQuotaManager;
        }
    }

    public static class Builder
    implements Stages.RequireAuthenticator,
    Stages.RequireAuthorizator,
    Stages.RequireEventBus,
    Stages.RequireAnnotationLimits,
    Stages.RequireMessageParser,
    Stages.RequireSearchIndex,
    Stages.RequirePreDeletionHooks,
    Stages.RequireQuotaManager,
    Stages.FinalStage {
        private Optional<Authenticator> authenticator = Optional.empty();
        private Optional<Authorizator> authorizator = Optional.empty();
        private Optional<EventBus> eventBus = Optional.empty();
        private Optional<Integer> limitAnnotationCount = Optional.empty();
        private Optional<Function<BaseQuotaComponentsStage, QuotaManager>> quotaManager;
        private Optional<Integer> limitAnnotationSize = Optional.empty();
        private Optional<MessageParser> messageParser;
        private Optional<Function<MailboxManagerSearchIndexStage, MessageSearchIndex>> searchIndexFactory = Optional.empty();
        private ImmutableSet.Builder<Function<MailboxManagerPreInstanciationStage, PreDeletionHook>> preDeletionHooksFactories;
        private ImmutableList.Builder<EventListener.GroupEventListener> listenersToBeRegistered;

        private Builder() {
            this.messageParser = Optional.empty();
            this.quotaManager = Optional.empty();
            this.preDeletionHooksFactories = ImmutableSet.builder();
            this.listenersToBeRegistered = ImmutableList.builder();
        }

        @Override
        public Builder messageParser(MessageParser messageParser) {
            this.messageParser = Optional.of(messageParser);
            return this;
        }

        @Override
        public Builder quotaManager(Function<BaseQuotaComponentsStage, QuotaManager> quotaManager) {
            this.quotaManager = Optional.of(quotaManager);
            return this;
        }

        @Override
        public Builder authenticator(Authenticator authenticator) {
            this.authenticator = Optional.of(authenticator);
            return this;
        }

        @Override
        public Builder authorizator(Authorizator authorizator) {
            this.authorizator = Optional.of(authorizator);
            return this;
        }

        @Override
        public Builder eventBus(EventBus eventBus) {
            this.eventBus = Optional.of(eventBus);
            return this;
        }

        @Override
        public Builder annotationLimits(int limitAnnotationCount, int limitAnnotationSize) {
            this.limitAnnotationCount = Optional.of(limitAnnotationCount);
            this.limitAnnotationSize = Optional.of(limitAnnotationSize);
            return this;
        }

        @Override
        public Builder preDeletionHooksFactories(Collection<Function<MailboxManagerPreInstanciationStage, PreDeletionHook>> preDeletionHooks) {
            this.preDeletionHooksFactories.addAll(preDeletionHooks);
            return this;
        }

        @Override
        public Builder searchIndex(Function<MailboxManagerSearchIndexStage, MessageSearchIndex> searchIndex) {
            this.searchIndexFactory = Optional.of(searchIndex);
            return this;
        }

        @Override
        public Builder listeningSearchIndex(Function<MailboxManagerSearchIndexStage, ListeningMessageSearchIndex> searchIndex) {
            this.searchIndexFactory = Optional.of(stage -> {
                ListeningMessageSearchIndex listeningMessageSearchIndex = (ListeningMessageSearchIndex)searchIndex.apply((MailboxManagerSearchIndexStage)stage);
                this.listenersToBeRegistered.add((Object)listeningMessageSearchIndex);
                return listeningMessageSearchIndex;
            });
            return this;
        }

        @Override
        public InMemoryIntegrationResources build() {
            Preconditions.checkState((boolean)this.authenticator.isPresent());
            Preconditions.checkState((boolean)this.authorizator.isPresent());
            Preconditions.checkState((boolean)this.eventBus.isPresent());
            Preconditions.checkState((boolean)this.quotaManager.isPresent());
            Preconditions.checkState((boolean)this.limitAnnotationSize.isPresent());
            Preconditions.checkState((boolean)this.limitAnnotationCount.isPresent());
            Preconditions.checkState((boolean)this.searchIndexFactory.isPresent());
            Preconditions.checkState((boolean)this.messageParser.isPresent());
            InMemoryMailboxSessionMapperFactory mailboxSessionMapperFactory = new InMemoryMailboxSessionMapperFactory();
            EventBus eventBus = this.eventBus.get();
            StoreRightManager storeRightManager = new StoreRightManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, (MailboxACLResolver)new UnionMailboxACLResolver(), eventBus);
            StoreMailboxAnnotationManager annotationManager = new StoreMailboxAnnotationManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, storeRightManager, this.limitAnnotationCount.get().intValue(), this.limitAnnotationSize.get().intValue());
            SessionProviderImpl sessionProvider = new SessionProviderImpl(this.authenticator.get(), this.authorizator.get());
            InMemoryPerUserMaxQuotaManager maxQuotaManager = new InMemoryPerUserMaxQuotaManager();
            DefaultUserQuotaRootResolver quotaRootResolver = new DefaultUserQuotaRootResolver((SessionProvider)sessionProvider, (MailboxSessionMapperFactory)mailboxSessionMapperFactory);
            CurrentQuotaCalculator currentQuotaCalculator = new CurrentQuotaCalculator((MailboxSessionMapperFactory)mailboxSessionMapperFactory, (QuotaRootResolver)quotaRootResolver);
            InMemoryCurrentQuotaManager currentQuotaManager = new InMemoryCurrentQuotaManager(currentQuotaCalculator, (SessionProvider)sessionProvider);
            QuotaManager quotaManager = this.quotaManager.get().apply(new BaseQuotaComponentsStage(maxQuotaManager, currentQuotaManager));
            ListeningCurrentQuotaUpdater listeningCurrentQuotaUpdater = new ListeningCurrentQuotaUpdater((CurrentQuotaManager)currentQuotaManager, (QuotaRootResolver)quotaRootResolver, eventBus, quotaManager);
            QuotaComponents quotaComponents = new QuotaComponents((MaxQuotaManager)maxQuotaManager, quotaManager, (QuotaRootResolver)quotaRootResolver);
            InMemoryMessageId.Factory messageIdFactory = new InMemoryMessageId.Factory();
            NaiveThreadIdGuessingAlgorithm threadIdGuessingAlgorithm = new NaiveThreadIdGuessingAlgorithm();
            MailboxManagerPreInstanciationStage preInstanciationStage = new MailboxManagerPreInstanciationStage(mailboxSessionMapperFactory, sessionProvider);
            PreDeletionHooks hooks = this.createHooks(preInstanciationStage);
            StoreMessageIdManager messageIdManager = new StoreMessageIdManager((RightManager)storeRightManager, (MailboxSessionMapperFactory)mailboxSessionMapperFactory, eventBus, quotaManager, (QuotaRootResolver)quotaRootResolver, hooks);
            StoreAttachmentManager attachmentManager = new StoreAttachmentManager((AttachmentMapperFactory)mailboxSessionMapperFactory, (MessageIdManager)messageIdManager);
            MailboxManagerSearchIndexStage searchIndexStage = new MailboxManagerSearchIndexStage(mailboxSessionMapperFactory, (SessionProvider)sessionProvider, (AttachmentContentLoader)attachmentManager);
            MessageSearchIndex index = this.searchIndexFactory.get().apply(searchIndexStage);
            InMemoryMailboxManager manager = new InMemoryMailboxManager((MailboxSessionMapperFactory)mailboxSessionMapperFactory, (SessionProvider)sessionProvider, (MailboxPathLocker)new JVMMailboxPathLocker(), this.messageParser.get(), (MessageId.Factory)messageIdFactory, eventBus, annotationManager, storeRightManager, quotaComponents, index, hooks, (ThreadIdGuessingAlgorithm)threadIdGuessingAlgorithm);
            eventBus.register((EventListener.ReactiveGroupEventListener)listeningCurrentQuotaUpdater);
            eventBus.register((EventListener.GroupEventListener)new MailboxAnnotationListener((MailboxSessionMapperFactory)mailboxSessionMapperFactory, (SessionProvider)sessionProvider));
            this.listenersToBeRegistered.build().forEach(arg_0 -> ((EventBus)eventBus).register(arg_0));
            return new InMemoryIntegrationResources(manager, storeRightManager, (MessageId.Factory)messageIdFactory, currentQuotaCalculator, currentQuotaManager, quotaRootResolver, maxQuotaManager, quotaManager, messageIdManager, index, eventBus, (AttachmentManager)attachmentManager);
        }

        private PreDeletionHooks createHooks(MailboxManagerPreInstanciationStage preInstanciationStage) {
            ImmutableSet preDeletionHooksSet = (ImmutableSet)this.preDeletionHooksFactories.build().stream().map(biFunction -> (PreDeletionHook)biFunction.apply(preInstanciationStage)).collect(ImmutableSet.toImmutableSet());
            return new PreDeletionHooks((Set)preDeletionHooksSet, (MetricFactory)new RecordingMetricFactory());
        }
    }

    public static interface Stages {

        public static interface FinalStage {
            public InMemoryIntegrationResources build();
        }

        public static interface RequireQuotaManager {
            public FinalStage quotaManager(Function<BaseQuotaComponentsStage, QuotaManager> var1);

            default public FinalStage storeQuotaManager() {
                return this.quotaManager((BaseQuotaComponentsStage stage) -> new StoreQuotaManager((CurrentQuotaManager)stage.currentQuotaManager, (MaxQuotaManager)stage.maxQuotaManager));
            }

            default public FinalStage quotaManager(QuotaManager quotaManager) {
                return this.quotaManager((BaseQuotaComponentsStage stage) -> quotaManager);
            }
        }

        public static interface RequirePreDeletionHooks {
            public RequireQuotaManager preDeletionHooksFactories(Collection<Function<MailboxManagerPreInstanciationStage, PreDeletionHook>> var1);

            default public RequireQuotaManager preDeletionHookFactory(Function<MailboxManagerPreInstanciationStage, PreDeletionHook> preDeletionHook) {
                return this.preDeletionHooksFactories((Collection<Function<MailboxManagerPreInstanciationStage, PreDeletionHook>>)ImmutableList.of(preDeletionHook));
            }

            default public RequireQuotaManager preDeletionHook(PreDeletionHook preDeletionHook) {
                return this.preDeletionHookFactory(RequirePreDeletionHooks.toFactory(preDeletionHook));
            }

            default public RequireQuotaManager preDeletionHooks(Collection<PreDeletionHook> preDeletionHooks) {
                return this.preDeletionHooksFactories((Collection)preDeletionHooks.stream().map(RequirePreDeletionHooks::toFactory).collect(ImmutableList.toImmutableList()));
            }

            default public RequireQuotaManager noPreDeletionHooks() {
                return this.preDeletionHooksFactories((Collection<Function<MailboxManagerPreInstanciationStage, PreDeletionHook>>)ImmutableList.of());
            }

            public static Function<MailboxManagerPreInstanciationStage, PreDeletionHook> toFactory(PreDeletionHook preDeletionHook) {
                return any -> preDeletionHook;
            }
        }

        public static interface RequireSearchIndex {
            public RequirePreDeletionHooks searchIndex(Function<MailboxManagerSearchIndexStage, MessageSearchIndex> var1);

            public RequirePreDeletionHooks listeningSearchIndex(Function<MailboxManagerSearchIndexStage, ListeningMessageSearchIndex> var1);

            default public RequirePreDeletionHooks scanningSearchIndex() {
                return this.searchIndex(stage -> new SimpleMessageSearchIndex((MessageMapperFactory)stage.mapperFactory, (MailboxMapperFactory)stage.mapperFactory, (TextExtractor)new DefaultTextExtractor(), stage.attachmentContentLoader));
            }
        }

        public static interface RequireMessageParser {
            public RequireSearchIndex messageParser(MessageParser var1);

            default public RequireSearchIndex defaultMessageParser() {
                return this.messageParser(new MessageParser());
            }
        }

        public static interface RequireAnnotationLimits {
            public RequireMessageParser annotationLimits(int var1, int var2);

            default public RequireMessageParser defaultAnnotationLimits() {
                return this.annotationLimits(10, 1024);
            }
        }

        public static interface RequireEventBus {
            public RequireAnnotationLimits eventBus(EventBus var1);

            default public RequireAnnotationLimits inVmEventBus() {
                return this.eventBus((EventBus)new InVMEventBus((EventDelivery)new InVmEventDelivery((MetricFactory)new RecordingMetricFactory()), EventBusTestFixture.RETRY_BACKOFF_CONFIGURATION, (EventDeadLetters)new MemoryEventDeadLetters()));
            }
        }

        public static interface RequireAuthorizator {
            public RequireEventBus authorizator(Authorizator var1);

            default public RequireEventBus fakeAuthorizator() {
                return this.authorizator((Authorizator)FakeAuthorizator.defaultReject());
            }
        }

        public static interface RequireAuthenticator {
            public RequireAuthorizator authenticator(Authenticator var1);

            default public RequireAuthorizator preProvisionnedFakeAuthenticator() {
                FakeAuthenticator fakeAuthenticator = new FakeAuthenticator();
                fakeAuthenticator.addUser(ManagerTestProvisionner.USER, "pass");
                fakeAuthenticator.addUser(ManagerTestProvisionner.OTHER_USER, "otherPass");
                return this.authenticator((Authenticator)fakeAuthenticator);
            }
        }
    }
}

