/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.quota;

import java.util.Optional;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.inmemory.quota.InMemoryCurrentQuotaManager;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.QuotaOperation;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.store.quota.CurrentQuotaCalculator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import reactor.core.publisher.Mono;

class InMemoryCurrentQuotaCalculatorTest {
    static final QuotaRoot QUOTA_ROOT = QuotaRoot.quotaRoot((String)"benwa", Optional.empty());
    static final CurrentQuotas CURRENT_QUOTAS = new CurrentQuotas(QuotaCountUsage.count((long)18L), QuotaSizeUsage.size((long)512L));
    InMemoryCurrentQuotaManager testee;
    CurrentQuotaCalculator mockedCurrentQuotaCalculator;

    InMemoryCurrentQuotaCalculatorTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockedCurrentQuotaCalculator = (CurrentQuotaCalculator)Mockito.mock(CurrentQuotaCalculator.class);
        this.testee = new InMemoryCurrentQuotaManager(this.mockedCurrentQuotaCalculator, (SessionProvider)Mockito.mock(SessionProvider.class));
    }

    @Test
    void getCurrentMessageCountShouldReturnRecalculateMessageCountWhenEntryIsNotInitialized() throws Exception {
        Mockito.when((Object)this.mockedCurrentQuotaCalculator.recalculateCurrentQuotas(QUOTA_ROOT, null)).thenReturn((Object)Mono.just((Object)CURRENT_QUOTAS));
        Assertions.assertThat((Object)((QuotaCountUsage)this.testee.getCurrentMessageCount(QUOTA_ROOT).block())).isEqualTo((Object)QuotaCountUsage.count((long)18L));
    }

    @Test
    void getCurrentStorageShouldReturnRecalculateSizeWhenEntryIsNotInitialized() throws Exception {
        Mockito.when((Object)this.mockedCurrentQuotaCalculator.recalculateCurrentQuotas(QUOTA_ROOT, null)).thenReturn((Object)Mono.just((Object)CURRENT_QUOTAS));
        Assertions.assertThat((Object)((QuotaSizeUsage)this.testee.getCurrentStorage(QUOTA_ROOT).block())).isEqualTo((Object)QuotaSizeUsage.size((long)512L));
    }

    @Test
    void getCurrentStorageShouldReRetrieveStoredQuotasWhenCalculateOnUnknownQuotaIsTrue() throws Exception {
        Mockito.when((Object)this.mockedCurrentQuotaCalculator.recalculateCurrentQuotas(QUOTA_ROOT, null)).thenReturn((Object)Mono.just((Object)CURRENT_QUOTAS));
        QuotaOperation quotaOperation = new QuotaOperation(QUOTA_ROOT, QuotaCountUsage.count((long)10L), QuotaSizeUsage.size((long)100L));
        this.testee.increase(quotaOperation).block();
        Assertions.assertThat((Object)((QuotaCountUsage)this.testee.getCurrentMessageCount(QUOTA_ROOT).block())).isEqualTo((Object)QuotaCountUsage.count((long)28L));
        Assertions.assertThat((Object)((QuotaSizeUsage)this.testee.getCurrentStorage(QUOTA_ROOT).block())).isEqualTo((Object)QuotaSizeUsage.size((long)612L));
    }

    @Test
    void getCurrentQuotasShouldReturnRecalculateQuotasWhenEntryIsNotInitialized() throws Exception {
        Mockito.when((Object)this.mockedCurrentQuotaCalculator.recalculateCurrentQuotas(QUOTA_ROOT, null)).thenReturn((Object)Mono.just((Object)CURRENT_QUOTAS));
        Assertions.assertThat((Object)((CurrentQuotas)this.testee.getCurrentQuotas(QUOTA_ROOT).block())).isEqualTo((Object)CURRENT_QUOTAS);
    }

    @Test
    void getCurrentQuotasShouldReRetrieveStoredQuotasWhenCalculateOnUnknownQuotaIsTrue() throws Exception {
        Mockito.when((Object)this.mockedCurrentQuotaCalculator.recalculateCurrentQuotas(QUOTA_ROOT, null)).thenReturn((Object)Mono.just((Object)CURRENT_QUOTAS));
        QuotaOperation quotaOperation = new QuotaOperation(QUOTA_ROOT, QuotaCountUsage.count((long)10L), QuotaSizeUsage.size((long)100L));
        this.testee.increase(quotaOperation).block();
        Assertions.assertThat((Object)((CurrentQuotas)this.testee.getCurrentQuotas(QUOTA_ROOT).block())).isEqualTo((Object)new CurrentQuotas(QuotaCountUsage.count((long)28L), QuotaSizeUsage.size((long)612L)));
    }
}

