/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tika.extractor;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.james.mailbox.extractor.ParsedContent;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.xml.sax.ContentHandler;

public class TikaTextExtractor
implements TextExtractor {
    private final Parser parser = new AutoDetectParser();

    public ParsedContent extractContent(InputStream inputStream, String contentType, String fileName) throws Exception {
        Metadata metadata = this.createInitializedMetadata(contentType, fileName);
        StringWriter stringWriter = new StringWriter();
        BodyContentHandler bodyContentHandler = new BodyContentHandler((Writer)stringWriter);
        this.parser.parse(inputStream, (ContentHandler)bodyContentHandler, metadata, new ParseContext());
        return new ParsedContent(stringWriter.toString(), this.convertMetadataToMultimap(metadata));
    }

    private Metadata createInitializedMetadata(String contentType, String fileName) {
        Metadata metadata = new Metadata();
        if (contentType != null) {
            metadata.set("Content-Type", contentType);
        }
        if (fileName != null) {
            metadata.set("resourceName", fileName);
        }
        return metadata;
    }

    private Map<String, List<String>> convertMetadataToMultimap(Metadata metadata) {
        return Arrays.stream(metadata.names()).map(name -> new MetadataEntry((String)name, Arrays.asList(metadata.getValues(name)))).reduce(new HashMap(), (metadataMultiMap, metadataEntry) -> {
            metadataMultiMap.put(metadataEntry.getName(), metadataEntry.getEntries());
            return metadataMultiMap;
        }, (metadataMultimap1, metadataMultimap2) -> {
            metadataMultimap1.putAll(metadataMultimap2);
            return metadataMultimap1;
        });
    }

    private static class MetadataEntry {
        private final String name;
        private final ImmutableList<String> entries;

        public MetadataEntry(String name, List<String> entries) {
            this.name = name;
            this.entries = ImmutableList.copyOf(entries);
        }

        public String getName() {
            return this.name;
        }

        public List<String> getEntries() {
            return this.entries;
        }
    }
}

