/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.task.Task;
import org.apache.james.util.streams.Iterators;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReIndexerPerformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReIndexerPerformer.class);
    private static final int NO_LIMIT = 0;
    private static final int SINGLE_MESSAGE = 1;
    private static final String RE_INDEXING = "re-indexing";
    private static final Username RE_INDEXER_PERFORMER_USER = Username.of((String)"re-indexing");
    private final MailboxManager mailboxManager;
    private final ListeningMessageSearchIndex messageSearchIndex;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;

    @Inject
    public ReIndexerPerformer(MailboxManager mailboxManager, ListeningMessageSearchIndex messageSearchIndex, MailboxSessionMapperFactory mailboxSessionMapperFactory) {
        this.mailboxManager = mailboxManager;
        this.messageSearchIndex = messageSearchIndex;
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task.Result reIndex(MailboxId mailboxId, ReprocessingContext reprocessingContext) throws Exception {
        LOGGER.info("Intend to reindex mailbox with mailboxId {}", (Object)mailboxId.serialize());
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(RE_INDEXER_PERFORMER_USER);
        Mailbox mailbox = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession).findMailboxById(mailboxId);
        this.messageSearchIndex.deleteAll(mailboxSession, mailboxId);
        try {
            Task.Result result = Iterators.toStream((Iterator)this.mailboxSessionMapperFactory.getMessageMapper(mailboxSession).listAllMessageUids(mailbox)).map(uid -> this.handleMessageReIndexing(mailboxSession, mailbox, (MessageUid)uid, reprocessingContext)).reduce(Task::combine).orElse(Task.Result.COMPLETED);
            return result;
        }
        finally {
            LOGGER.info("Finish to reindex mailbox with mailboxId {}", (Object)mailboxId.serialize());
        }
    }

    Task.Result reIndex(ReprocessingContext reprocessingContext, ReIndexingExecutionFailures previousReIndexingFailures) {
        return previousReIndexingFailures.failures().stream().map(previousFailure -> this.reIndex(reprocessingContext, (ReIndexingExecutionFailures.ReIndexingFailure)previousFailure)).reduce(Task::combine).orElse(Task.Result.COMPLETED);
    }

    private Task.Result reIndex(ReprocessingContext reprocessingContext, ReIndexingExecutionFailures.ReIndexingFailure previousReIndexingFailure) {
        MailboxId mailboxId = previousReIndexingFailure.getMailboxId();
        MessageUid uid = previousReIndexingFailure.getUid();
        try {
            return this.handleMessageReIndexing(mailboxId, uid, reprocessingContext);
        }
        catch (MailboxException e) {
            LOGGER.warn("ReIndexing failed for {} {}", new Object[]{mailboxId, uid, e});
            reprocessingContext.recordFailureDetailsForMessage(mailboxId, uid);
            return Task.Result.PARTIAL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task.Result reIndex(ReprocessingContext reprocessingContext) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(RE_INDEXER_PERFORMER_USER);
        LOGGER.info("Starting a full reindex");
        Stream<MailboxId> mailboxIds = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession).list().stream().map(Mailbox::getMailboxId);
        try {
            Task.Result result = this.reIndex(mailboxIds, reprocessingContext);
            return result;
        }
        finally {
            LOGGER.info("Full reindex finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task.Result reIndex(Username username, ReprocessingContext reprocessingContext) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        LOGGER.info("Starting a reindex for user {}", (Object)username.asString());
        Stream<MailboxId> mailboxIds = this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)mailboxSession).build(), mailboxSession).stream().map(MailboxMetaData::getId);
        try {
            Task.Result result = this.reIndex(mailboxIds, reprocessingContext);
            return result;
        }
        finally {
            LOGGER.info("User {} reindex finished", (Object)username.asString());
        }
    }

    Task.Result handleMessageReIndexing(MailboxId mailboxId, MessageUid uid, ReprocessingContext reprocessingContext) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(RE_INDEXER_PERFORMER_USER);
        Mailbox mailbox = this.mailboxSessionMapperFactory.getMailboxMapper(mailboxSession).findMailboxById(mailboxId);
        return this.handleMessageReIndexing(mailboxSession, mailbox, uid, reprocessingContext);
    }

    Task.Result handleMessageIdReindexing(MessageId messageId) {
        try {
            MailboxSession session = this.mailboxManager.createSystemSession(RE_INDEXER_PERFORMER_USER);
            return this.mailboxSessionMapperFactory.getMessageIdMapper(session).find((Collection)ImmutableList.of((Object)messageId), MessageMapper.FetchType.Full).stream().map(mailboxMessage -> this.reIndex((MailboxMessage)mailboxMessage, session)).reduce(Task::combine).orElse(Task.Result.COMPLETED);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to re-index {}", (Object)messageId, (Object)e);
            return Task.Result.PARTIAL;
        }
    }

    private Task.Result reIndex(MailboxMessage mailboxMessage, MailboxSession session) {
        try {
            MailboxMapper mailboxMapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
            Mailbox mailbox = mailboxMapper.findMailboxById(mailboxMessage.getMailboxId());
            this.messageSearchIndex.add(session, mailbox, mailboxMessage);
            return Task.Result.COMPLETED;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to re-index {} in {}", new Object[]{mailboxMessage.getUid(), mailboxMessage.getMailboxId(), e});
            return Task.Result.PARTIAL;
        }
    }

    private Task.Result reIndex(Stream<MailboxId> mailboxIds, ReprocessingContext reprocessingContext) {
        return mailboxIds.map(mailboxId -> {
            try {
                return this.reIndex((MailboxId)mailboxId, reprocessingContext);
            }
            catch (Throwable e) {
                LOGGER.error("Error while proceeding to full reindexing on mailbox with mailboxId {}", (Object)mailboxId.serialize(), (Object)e);
                return Task.Result.PARTIAL;
            }
        }).reduce(Task::combine).orElse(Task.Result.COMPLETED);
    }

    private Task.Result handleMessageReIndexing(MailboxSession mailboxSession, Mailbox mailbox, MessageUid uid, ReprocessingContext reprocessingContext) {
        try {
            Optional.of(uid).flatMap(Throwing.function(mUid -> this.fullyReadMessage(mailboxSession, mailbox, (MessageUid)mUid))).ifPresent(Throwing.consumer(message -> this.messageSearchIndex.add(mailboxSession, mailbox, message)));
            reprocessingContext.recordSuccess();
            return Task.Result.COMPLETED;
        }
        catch (Exception e) {
            LOGGER.warn("ReIndexing failed for {} {}", new Object[]{mailbox.generateAssociatedPath(), uid, e});
            reprocessingContext.recordFailureDetailsForMessage(mailbox.getMailboxId(), uid);
            return Task.Result.PARTIAL;
        }
    }

    private Optional<MailboxMessage> fullyReadMessage(MailboxSession mailboxSession, Mailbox mailbox, MessageUid mUid) throws MailboxException {
        return Iterators.toStream((Iterator)this.mailboxSessionMapperFactory.getMessageMapper(mailboxSession).findInMailbox(mailbox, MessageRange.one((MessageUid)mUid), MessageMapper.FetchType.Full, 1)).findFirst();
    }
}

