/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Clock;
import java.time.Instant;
import org.apache.james.mailbox.indexer.IndexingDetailInformation;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.mailbox.tools.indexer.ReprocessingContext;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformationDTO;
import org.apache.mailbox.tools.indexer.SerializableReIndexingExecutionFailures;

public class ReprocessingContextInformation
implements TaskExecutionDetails.AdditionalInformation,
IndexingDetailInformation {
    private final int successfullyReprocessedMailCount;
    private final int failedReprocessedMailCount;
    private final ReIndexingExecutionFailures failures;
    private final Instant timestamp;

    public static ReprocessingContextInformationDTO.ReprocessingContextInformationForErrorRecoveryIndexationTask forErrorRecoveryIndexationTask(ReprocessingContext reprocessingContext) {
        return new ReprocessingContextInformationDTO.ReprocessingContextInformationForErrorRecoveryIndexationTask(reprocessingContext.successfullyReprocessedMailCount(), reprocessingContext.failedReprocessingMailCount(), reprocessingContext.failures(), Clock.systemUTC().instant());
    }

    public static ReprocessingContextInformationDTO.ReprocessingContextInformationForFullReindexingTask forFullReindexingTask(ReprocessingContext reprocessingContext) {
        return new ReprocessingContextInformationDTO.ReprocessingContextInformationForFullReindexingTask(reprocessingContext.successfullyReprocessedMailCount(), reprocessingContext.failedReprocessingMailCount(), reprocessingContext.failures(), Clock.systemUTC().instant());
    }

    ReprocessingContextInformation(int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp) {
        this.successfullyReprocessedMailCount = successfullyReprocessedMailCount;
        this.failedReprocessedMailCount = failedReprocessedMailCount;
        this.failures = failures;
        this.timestamp = timestamp;
    }

    public int getSuccessfullyReprocessedMailCount() {
        return this.successfullyReprocessedMailCount;
    }

    public int getFailedReprocessedMailCount() {
        return this.failedReprocessedMailCount;
    }

    @JsonIgnore
    public ReIndexingExecutionFailures failures() {
        return this.failures;
    }

    @JsonProperty(value="failures")
    public SerializableReIndexingExecutionFailures failuresAsJson() {
        return SerializableReIndexingExecutionFailures.from(this.failures());
    }

    public Instant timestamp() {
        return this.timestamp;
    }
}

