/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.indexer.ReIndexingExecutionFailures;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.mailbox.tools.indexer.ErrorRecoveryIndexationTask;
import org.apache.mailbox.tools.indexer.FullReindexingTask;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformation;

public class ReprocessingContextInformationDTO
implements AdditionalInformationDTO {
    protected final String type;
    protected final int successfullyReprocessedMailCount;
    protected final int failedReprocessedMailCount;
    protected final List<ReindexingFailureDTO> failures;
    protected final Instant timestamp;

    static ReIndexingExecutionFailures deserializeFailures(MailboxId.Factory mailboxIdFactory, List<ReindexingFailureDTO> failures) {
        List reIndexingFailures = (List)failures.stream().flatMap(failuresForMailbox -> ReprocessingContextInformationDTO.getReIndexingFailureStream(mailboxIdFactory, failuresForMailbox)).collect(Guavate.toImmutableList());
        return new ReIndexingExecutionFailures(reIndexingFailures);
    }

    private static Stream<ReIndexingExecutionFailures.ReIndexingFailure> getReIndexingFailureStream(MailboxId.Factory mailboxIdFactory, ReindexingFailureDTO failuresForMailbox) {
        return failuresForMailbox.uids.stream().map(uid -> new ReIndexingExecutionFailures.ReIndexingFailure(mailboxIdFactory.fromString(failuresForMailbox.mailboxId), MessageUid.of((long)uid)));
    }

    static List<ReindexingFailureDTO> serializeFailures(ReIndexingExecutionFailures failures) {
        ImmutableListMultimap failuresByMailbox = (ImmutableListMultimap)failures.failures().stream().collect(Guavate.toImmutableListMultimap(ReIndexingExecutionFailures.ReIndexingFailure::getMailboxId));
        return (List)failuresByMailbox.asMap().entrySet().stream().map(failureByMailbox -> new ReindexingFailureDTO(((MailboxId)failureByMailbox.getKey()).serialize(), (List)ReprocessingContextInformationDTO.extractMessageUidsFromFailure(failureByMailbox))).collect(Guavate.toImmutableList());
    }

    private static ImmutableList<Long> extractMessageUidsFromFailure(Map.Entry<MailboxId, Collection<ReIndexingExecutionFailures.ReIndexingFailure>> failureByMailbox) {
        return (ImmutableList)failureByMailbox.getValue().stream().map(failure -> failure.getUid().asLong()).collect(Guavate.toImmutableList());
    }

    ReprocessingContextInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="successfullyReprocessedMailCount") int successfullyReprocessedMailCount, @JsonProperty(value="failedReprocessedMailCount") int failedReprocessedMailCount, @JsonProperty(value="failures") List<ReindexingFailureDTO> failures, @JsonProperty(value="timestamp") Instant timestamp) {
        this.type = type;
        this.successfullyReprocessedMailCount = successfullyReprocessedMailCount;
        this.failedReprocessedMailCount = failedReprocessedMailCount;
        this.failures = failures;
        this.timestamp = timestamp;
    }

    public int getSuccessfullyReprocessedMailCount() {
        return this.successfullyReprocessedMailCount;
    }

    public int getFailedReprocessedMailCount() {
        return this.failedReprocessedMailCount;
    }

    public List<ReindexingFailureDTO> getFailures() {
        return this.failures;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public static class ReprocessingContextInformationForFullReindexingTask
    extends ReprocessingContextInformation {
        public static final AdditionalInformationDTOModule<ReprocessingContextInformationForFullReindexingTask, DTO> serializationModule(MailboxId.Factory mailboxIdFactory) {
            return (AdditionalInformationDTOModule)DTOModule.forDomainObject(ReprocessingContextInformationForFullReindexingTask.class).convertToDTO(DTO.class).toDomainObjectConverter(dto -> new ReprocessingContextInformationForFullReindexingTask(dto.successfullyReprocessedMailCount, dto.failedReprocessedMailCount, ReprocessingContextInformationDTO.deserializeFailures(mailboxIdFactory, dto.failures), dto.getTimestamp())).toDTOConverter((details, type) -> new DTO(type, details.getSuccessfullyReprocessedMailCount(), details.getFailedReprocessedMailCount(), ReprocessingContextInformationDTO.serializeFailures(details.failures()), details.timestamp())).typeName(FullReindexingTask.FULL_RE_INDEXING.asString()).withFactory(AdditionalInformationDTOModule::new);
        }

        ReprocessingContextInformationForFullReindexingTask(int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp) {
            super(successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp);
        }

        public static class DTO
        extends ReprocessingContextInformationDTO {
            DTO(@JsonProperty(value="type") String type, @JsonProperty(value="successfullyReprocessedMailCount") int successfullyReprocessedMailCount, @JsonProperty(value="failedReprocessedMailCount") int failedReprocessedMailCount, @JsonProperty(value="failures") List<ReindexingFailureDTO> failures, @JsonProperty(value="timestamp") Instant timestamp) {
                super(type, successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp);
            }
        }
    }

    public static class ReprocessingContextInformationForErrorRecoveryIndexationTask
    extends ReprocessingContextInformation {
        public static final AdditionalInformationDTOModule<ReprocessingContextInformationForErrorRecoveryIndexationTask, DTO> serializationModule(MailboxId.Factory mailboxIdFactory) {
            return (AdditionalInformationDTOModule)DTOModule.forDomainObject(ReprocessingContextInformationForErrorRecoveryIndexationTask.class).convertToDTO(DTO.class).toDomainObjectConverter(dto -> new ReprocessingContextInformationForErrorRecoveryIndexationTask(dto.successfullyReprocessedMailCount, dto.failedReprocessedMailCount, ReprocessingContextInformationDTO.deserializeFailures(mailboxIdFactory, dto.failures), dto.getTimestamp())).toDTOConverter((details, type) -> new DTO(type, details.getSuccessfullyReprocessedMailCount(), details.getFailedReprocessedMailCount(), ReprocessingContextInformationDTO.serializeFailures(details.failures()), details.timestamp())).typeName(ErrorRecoveryIndexationTask.PREVIOUS_FAILURES_INDEXING.asString()).withFactory(AdditionalInformationDTOModule::new);
        }

        ReprocessingContextInformationForErrorRecoveryIndexationTask(int successfullyReprocessedMailCount, int failedReprocessedMailCount, ReIndexingExecutionFailures failures, Instant timestamp) {
            super(successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp);
        }

        public static class DTO
        extends ReprocessingContextInformationDTO {
            DTO(@JsonProperty(value="type") String type, @JsonProperty(value="successfullyReprocessedMailCount") int successfullyReprocessedMailCount, @JsonProperty(value="failedReprocessedMailCount") int failedReprocessedMailCount, @JsonProperty(value="failures") List<ReindexingFailureDTO> failures, @JsonProperty(value="timestamp") Instant timestamp) {
                super(type, successfullyReprocessedMailCount, failedReprocessedMailCount, failures, timestamp);
            }
        }
    }

    public static class ReindexingFailureDTO {
        private final String mailboxId;
        private final List<Long> uids;

        private ReindexingFailureDTO(@JsonProperty(value="mailboxId") String mailboxId, @JsonProperty(value="uids") List<Long> uids) {
            this.mailboxId = mailboxId;
            this.uids = uids;
        }

        public String getMailboxId() {
            return this.mailboxId;
        }

        public List<Long> getUids() {
            return this.uids;
        }
    }
}

