/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.james.util.Port;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscardProtocol {
    private static final int SOCKET_CONNECTION_WAIT_MILLIS = 30;
    private static final int IDLE_TIMEOUT = 120000;
    private static final Logger LOG = LoggerFactory.getLogger(DiscardProtocol.class);
    private Port port;
    private final Queue<Server> queue = new LinkedList<Server>();
    private final Collection<Server> runningServers = new LinkedList<Server>();
    private volatile ServerSocketChannel socket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        Queue<Server> queue = this.queue;
        synchronized (queue) {
            if (this.socket != null) {
                throw new IllegalStateException("Already started");
            }
            this.socket = ServerSocketChannel.open();
            this.socket.socket().bind(new InetSocketAddress(0));
            this.port = new Port(this.socket.socket().getLocalPort());
            this.socket.configureBlocking(false);
            Thread socketMonitorThread = new Thread(new SocketMonitor());
            socketMonitorThread.start();
        }
    }

    public Port getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record recordNext() {
        Queue<Server> queue = this.queue;
        synchronized (queue) {
            Server server = new Server();
            this.queue.add(server);
            return server;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort() {
        Queue<Server> queue = this.queue;
        synchronized (queue) {
            this.stop();
            for (Server server : this.queue) {
                server.abort();
            }
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Queue<Server> queue = this.queue;
        synchronized (queue) {
            try {
                if (this.socket != null && this.socket.isOpen()) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to close socket", (Throwable)e);
            }
            this.socket = null;
            for (Server server : this.runningServers) {
                server.abort();
            }
        }
    }

    private static final class Server
    implements Runnable,
    Record {
        private static final int COMPLETION_TIMEOUT = 60000;
        private static final int COMPLETION_PAUSE = 1000;
        private static final int INITIAL_BUFFER_CAPACITY = 2048;
        private final ByteBuffer buffer;
        private final StringBuffer out = new StringBuffer(2048);
        private SocketChannel socketChannel = null;
        private volatile boolean aborted = false;
        private volatile boolean complete = false;

        public Server() {
            this.buffer = ByteBuffer.allocate(2048);
        }

        public void setSocketChannel(SocketChannel socketChannel) {
            this.socketChannel = socketChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block23: {
                try {
                    if (this.socketChannel == null) {
                        LOG.error("Socket channel must be set before instance is run.");
                        break block23;
                    }
                    try {
                        while (!this.socketChannel.finishConnect()) {
                            Thread.sleep(30L);
                        }
                        int read = 0;
                        while (!this.aborted && this.socketChannel.isOpen() && read >= 0) {
                            read = this.socketChannel.read(this.buffer);
                            if (this.buffer.hasRemaining()) continue;
                            this.decant();
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Socket communication failed", (Throwable)e);
                        this.aborted = true;
                    }
                    finally {
                        try {
                            this.socketChannel.close();
                        }
                        catch (Exception e) {
                            LOG.debug("Ignoring failure to close socket.", (Throwable)e);
                        }
                    }
                }
                finally {
                    Server server = this;
                    synchronized (server) {
                        this.complete = true;
                        this.notifyAll();
                    }
                }
            }
        }

        private void decant() {
            this.buffer.flip();
            CharBuffer decoded = StandardCharsets.US_ASCII.decode(this.buffer);
            this.out.append(decoded);
            this.buffer.clear();
        }

        public void abort() {
            this.aborted = true;
        }

        @Override
        public synchronized String complete() throws Exception {
            if (this.aborted) {
                throw new Exception("Aborted");
            }
            long startTime = System.currentTimeMillis();
            boolean isTimedOut = false;
            while (!this.complete && !isTimedOut) {
                this.wait(1000L);
                isTimedOut = System.currentTimeMillis() - startTime > 60000L;
            }
            if (isTimedOut && !this.complete) {
                throw new Exception("Timed out wait for be notified that read is complete");
            }
            this.decant();
            return this.out.toString();
        }
    }

    public static interface Record {
        public String complete() throws Exception;
    }

    private final class SocketMonitor
    implements Runnable {
        private SocketMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                long lastConnection = System.currentTimeMillis();
                while (DiscardProtocol.this.socket != null) {
                    SocketChannel socketChannel = DiscardProtocol.this.socket.accept();
                    if (socketChannel == null) {
                        if (System.currentTimeMillis() - lastConnection > 120000L) {
                            throw new Exception("Idle timeout");
                        }
                        Thread.sleep(30L);
                        continue;
                    }
                    Queue<Server> queue = DiscardProtocol.this.queue;
                    synchronized (queue) {
                        Server nextServer = DiscardProtocol.this.queue.poll();
                        if (nextServer == null) {
                            nextServer = new Server();
                        }
                        nextServer.setSocketChannel(socketChannel);
                        Thread channelThread = new Thread(nextServer);
                        channelThread.start();
                        DiscardProtocol.this.runningServers.add(nextServer);
                        lastConnection = System.currentTimeMillis();
                    }
                }
                return;
            }
            catch (Exception e) {
                LOG.error("Cannot accept connection", (Throwable)e);
                DiscardProtocol.this.abort();
            }
        }
    }
}

