/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mpt;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import javax.net.SocketFactory;
import org.apache.james.mpt.DiscardProtocol;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DiscardProtocolTest {
    private static final String INPUT = "One, two, three - Testing";
    private DiscardProtocol protocol;
    private Socket socket;
    private DiscardProtocol.Record record;

    DiscardProtocolTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.protocol = new DiscardProtocol();
        this.protocol.start();
        this.socket = SocketFactory.getDefault().createSocket("127.0.0.1", this.protocol.getPort().getValue());
        this.record = this.protocol.recordNext();
        Assertions.assertThat((boolean)this.socket.isConnected()).isTrue();
    }

    @AfterEach
    void tearDown() {
        this.protocol.stop();
    }

    @Test
    void testRecord() throws Exception {
        this.input();
        String output = this.record.complete();
        Assertions.assertThat((String)output).isEqualTo(INPUT);
    }

    private void input() throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(this.socket.getOutputStream());
        ((Writer)out).append(INPUT);
        ((Writer)out).flush();
        ((Writer)out).close();
        this.socket.close();
    }

    @Test
    void testComplete() throws Exception {
        InputLater inputLater = new InputLater();
        Thread thread = new Thread(inputLater);
        thread.start();
        String output = this.record.complete();
        Assertions.assertThat((String)output).isEqualTo(INPUT);
        inputLater.assertExecutedSuccessfully();
    }

    private final class InputLater
    implements Runnable {
        private Exception e;

        private InputLater() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                DiscardProtocolTest.this.input();
            }
            catch (Exception e) {
                this.e = e;
            }
        }

        void assertExecutedSuccessfully() throws Exception {
            if (this.e != null) {
                this.e.printStackTrace();
                throw this.e;
            }
        }
    }
}

